@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.kotlin.outputs.RunAsCredentialAssociationPropertyResponse
import com.pulumi.azurenative.automation.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.automation.kotlin.outputs.RunAsCredentialAssociationPropertyResponse.Companion.toKotlin as runAsCredentialAssociationPropertyResponseToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [HybridRunbookWorkerGroup].
 */
@PulumiTagMarker
public class HybridRunbookWorkerGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HybridRunbookWorkerGroupArgs = HybridRunbookWorkerGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HybridRunbookWorkerGroupArgsBuilder.() -> Unit) {
        val builder = HybridRunbookWorkerGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HybridRunbookWorkerGroup {
        val builtJavaResource =
            com.pulumi.azurenative.automation.HybridRunbookWorkerGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HybridRunbookWorkerGroup(builtJavaResource)
    }
}

/**
 * Definition of hybrid runbook worker group.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2021-06-22.
 * Other available API versions: 2021-06-22, 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create a hybrid worker group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hybridRunbookWorkerGroup = new AzureNative.Automation.HybridRunbookWorkerGroup("hybridRunbookWorkerGroup", new()
 *     {
 *         AutomationAccountName = "testaccount",
 *         Credential = new AzureNative.Automation.Inputs.RunAsCredentialAssociationPropertyArgs
 *         {
 *             Name = "myRunAsCredentialName",
 *         },
 *         HybridRunbookWorkerGroupName = "TestHybridGroup",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewHybridRunbookWorkerGroup(ctx, "hybridRunbookWorkerGroup", &automation.HybridRunbookWorkerGroupArgs{
 * 			AutomationAccountName: pulumi.String("testaccount"),
 * 			Credential: &automation.RunAsCredentialAssociationPropertyArgs{
 * 				Name: pulumi.String("myRunAsCredentialName"),
 * 			},
 * 			HybridRunbookWorkerGroupName: pulumi.String("TestHybridGroup"),
 * 			ResourceGroupName:            pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.HybridRunbookWorkerGroup;
 * import com.pulumi.azurenative.automation.HybridRunbookWorkerGroupArgs;
 * import com.pulumi.azurenative.automation.inputs.RunAsCredentialAssociationPropertyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hybridRunbookWorkerGroup = new HybridRunbookWorkerGroup("hybridRunbookWorkerGroup", HybridRunbookWorkerGroupArgs.builder()
 *             .automationAccountName("testaccount")
 *             .credential(RunAsCredentialAssociationPropertyArgs.builder()
 *                 .name("myRunAsCredentialName")
 *                 .build())
 *             .hybridRunbookWorkerGroupName("TestHybridGroup")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:HybridRunbookWorkerGroup TestHybridGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/hybridRunbookWorkerGroups/{hybridRunbookWorkerGroupName}
 * ```
 */
public class HybridRunbookWorkerGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.HybridRunbookWorkerGroup,
) : KotlinCustomResource(javaResource, HybridRunbookWorkerGroupMapper) {
    /**
     * Sets the credential of a worker group.
     */
    public val credential: Output<RunAsCredentialAssociationPropertyResponse>?
        get() = javaResource.credential().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    runAsCredentialAssociationPropertyResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Type of the HybridWorkerGroup.
     */
    public val groupType: Output<String>?
        get() = javaResource.groupType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource system metadata.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object HybridRunbookWorkerGroupMapper : ResourceMapper<HybridRunbookWorkerGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.HybridRunbookWorkerGroup::class == javaResource::class

    override fun map(javaResource: Resource): HybridRunbookWorkerGroup =
        HybridRunbookWorkerGroup(
            javaResource as
                com.pulumi.azurenative.automation.HybridRunbookWorkerGroup,
        )
}

/**
 * @see [HybridRunbookWorkerGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HybridRunbookWorkerGroup].
 */
public suspend fun hybridRunbookWorkerGroup(
    name: String,
    block: suspend HybridRunbookWorkerGroupResourceBuilder.() -> Unit,
): HybridRunbookWorkerGroup {
    val builder = HybridRunbookWorkerGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HybridRunbookWorkerGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hybridRunbookWorkerGroup(name: String): HybridRunbookWorkerGroup {
    val builder = HybridRunbookWorkerGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
