@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.HybridRunbookWorkerGroupArgs.builder
import com.pulumi.azurenative.automation.kotlin.inputs.RunAsCredentialAssociationPropertyArgs
import com.pulumi.azurenative.automation.kotlin.inputs.RunAsCredentialAssociationPropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Definition of hybrid runbook worker group.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2021-06-22.
 * Other available API versions: 2021-06-22, 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create a hybrid worker group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hybridRunbookWorkerGroup = new AzureNative.Automation.HybridRunbookWorkerGroup("hybridRunbookWorkerGroup", new()
 *     {
 *         AutomationAccountName = "testaccount",
 *         Credential = new AzureNative.Automation.Inputs.RunAsCredentialAssociationPropertyArgs
 *         {
 *             Name = "myRunAsCredentialName",
 *         },
 *         HybridRunbookWorkerGroupName = "TestHybridGroup",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewHybridRunbookWorkerGroup(ctx, "hybridRunbookWorkerGroup", &automation.HybridRunbookWorkerGroupArgs{
 * 			AutomationAccountName: pulumi.String("testaccount"),
 * 			Credential: &automation.RunAsCredentialAssociationPropertyArgs{
 * 				Name: pulumi.String("myRunAsCredentialName"),
 * 			},
 * 			HybridRunbookWorkerGroupName: pulumi.String("TestHybridGroup"),
 * 			ResourceGroupName:            pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.HybridRunbookWorkerGroup;
 * import com.pulumi.azurenative.automation.HybridRunbookWorkerGroupArgs;
 * import com.pulumi.azurenative.automation.inputs.RunAsCredentialAssociationPropertyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hybridRunbookWorkerGroup = new HybridRunbookWorkerGroup("hybridRunbookWorkerGroup", HybridRunbookWorkerGroupArgs.builder()
 *             .automationAccountName("testaccount")
 *             .credential(RunAsCredentialAssociationPropertyArgs.builder()
 *                 .name("myRunAsCredentialName")
 *                 .build())
 *             .hybridRunbookWorkerGroupName("TestHybridGroup")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:HybridRunbookWorkerGroup TestHybridGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/hybridRunbookWorkerGroups/{hybridRunbookWorkerGroupName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property credential Sets the credential of a worker group.
 * @property hybridRunbookWorkerGroupName The hybrid runbook worker group name
 * @property name Gets or sets the name of the resource.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class HybridRunbookWorkerGroupArgs(
    public val automationAccountName: Output<String>? = null,
    public val credential: Output<RunAsCredentialAssociationPropertyArgs>? = null,
    public val hybridRunbookWorkerGroupName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.HybridRunbookWorkerGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.HybridRunbookWorkerGroupArgs =
        com.pulumi.azurenative.automation.HybridRunbookWorkerGroupArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .credential(credential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hybridRunbookWorkerGroupName(hybridRunbookWorkerGroupName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HybridRunbookWorkerGroupArgs].
 */
@PulumiTagMarker
public class HybridRunbookWorkerGroupArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var credential: Output<RunAsCredentialAssociationPropertyArgs>? = null

    private var hybridRunbookWorkerGroupName: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("yxtkdfpauxlaqddt")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value Sets the credential of a worker group.
     */
    @JvmName("smkjxkyhswtssljo")
    public suspend fun credential(`value`: Output<RunAsCredentialAssociationPropertyArgs>) {
        this.credential = value
    }

    /**
     * @param value The hybrid runbook worker group name
     */
    @JvmName("tqybyhindtylhabw")
    public suspend fun hybridRunbookWorkerGroupName(`value`: Output<String>) {
        this.hybridRunbookWorkerGroupName = value
    }

    /**
     * @param value Gets or sets the name of the resource.
     */
    @JvmName("oacclnlhureodydd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("udejutyiywfslroh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("ldsycjhttwfkifiy")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value Sets the credential of a worker group.
     */
    @JvmName("swigbeugivlbaang")
    public suspend fun credential(`value`: RunAsCredentialAssociationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param argument Sets the credential of a worker group.
     */
    @JvmName("uoplprsbalyhlake")
    public suspend fun credential(argument: suspend RunAsCredentialAssociationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = RunAsCredentialAssociationPropertyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.credential = mapped
    }

    /**
     * @param value The hybrid runbook worker group name
     */
    @JvmName("wxagnjbsxtqpnwgq")
    public suspend fun hybridRunbookWorkerGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hybridRunbookWorkerGroupName = mapped
    }

    /**
     * @param value Gets or sets the name of the resource.
     */
    @JvmName("ylwnvgphqvqunmjm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("pnloybuvurypoabn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): HybridRunbookWorkerGroupArgs = HybridRunbookWorkerGroupArgs(
        automationAccountName = automationAccountName,
        credential = credential,
        hybridRunbookWorkerGroupName = hybridRunbookWorkerGroupName,
        name = name,
        resourceGroupName = resourceGroupName,
    )
}
