@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.kotlin.outputs.ContentLinkResponse
import com.pulumi.azurenative.automation.kotlin.outputs.ModuleErrorInfoResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.automation.kotlin.outputs.ContentLinkResponse.Companion.toKotlin as contentLinkResponseToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.ModuleErrorInfoResponse.Companion.toKotlin as moduleErrorInfoResponseToKotlin

/**
 * Builder for [Module].
 */
@PulumiTagMarker
public class ModuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ModuleArgs = ModuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ModuleArgsBuilder.() -> Unit) {
        val builder = ModuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Module {
        val builtJavaResource = com.pulumi.azurenative.automation.Module(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Module(builtJavaResource)
    }
}

/**
 * Definition of the module type.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update a module
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var module = new AzureNative.Automation.Module("module", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount33",
 *         ContentLink = new AzureNative.Automation.Inputs.ContentLinkArgs
 *         {
 *             ContentHash = new AzureNative.Automation.Inputs.ContentHashArgs
 *             {
 *                 Algorithm = "sha265",
 *                 Value = "07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A",
 *             },
 *             Uri = "https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip",
 *             Version = "1.0.0.0",
 *         },
 *         ModuleName = "OmsCompositeResources",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewModule(ctx, "module", &automation.ModuleArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount33"),
 * 			ContentLink: &automation.ContentLinkArgs{
 * 				ContentHash: &automation.ContentHashArgs{
 * 					Algorithm: pulumi.String("sha265"),
 * 					Value:     pulumi.String("07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A"),
 * 				},
 * 				Uri:     pulumi.String("https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip"),
 * 				Version: pulumi.String("1.0.0.0"),
 * 			},
 * 			ModuleName:        pulumi.String("OmsCompositeResources"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Module;
 * import com.pulumi.azurenative.automation.ModuleArgs;
 * import com.pulumi.azurenative.automation.inputs.ContentLinkArgs;
 * import com.pulumi.azurenative.automation.inputs.ContentHashArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var module = new Module("module", ModuleArgs.builder()
 *             .automationAccountName("myAutomationAccount33")
 *             .contentLink(ContentLinkArgs.builder()
 *                 .contentHash(ContentHashArgs.builder()
 *                     .algorithm("sha265")
 *                     .value("07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A")
 *                     .build())
 *                 .uri("https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip")
 *                 .version("1.0.0.0")
 *                 .build())
 *             .moduleName("OmsCompositeResources")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Module OmsCompositeResources /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/modules/{moduleName}
 * ```
 */
public class Module internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.Module,
) : KotlinCustomResource(javaResource, ModuleMapper) {
    /**
     * Gets or sets the activity count of the module.
     */
    public val activityCount: Output<Int>?
        get() = javaResource.activityCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the contentLink of the module.
     */
    public val contentLink: Output<ContentLinkResponse>?
        get() = javaResource.contentLink().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    contentLinkResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the creation time.
     */
    public val creationTime: Output<String>?
        get() = javaResource.creationTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the error info of the module.
     */
    public val error: Output<ModuleErrorInfoResponse>?
        get() = javaResource.error().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    moduleErrorInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the etag of the resource.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets type of module, if its composite or not.
     */
    public val isComposite: Output<Boolean>?
        get() = javaResource.isComposite().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the isGlobal flag of the module.
     */
    public val isGlobal: Output<Boolean>?
        get() = javaResource.isGlobal().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the last modified time.
     */
    public val lastModifiedTime: Output<String>?
        get() = javaResource.lastModifiedTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Azure Region where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the provisioning state of the module.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the size in bytes of the module.
     */
    public val sizeInBytes: Output<Double>?
        get() = javaResource.sizeInBytes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the version of the module.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ModuleMapper : ResourceMapper<Module> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.Module::class == javaResource::class

    override fun map(javaResource: Resource): Module = Module(
        javaResource as
            com.pulumi.azurenative.automation.Module,
    )
}

/**
 * @see [Module].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Module].
 */
public suspend fun module(name: String, block: suspend ModuleResourceBuilder.() -> Unit): Module {
    val builder = ModuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Module].
 * @param name The _unique_ name of the resulting resource.
 */
public fun module(name: String): Module {
    val builder = ModuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
