@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.ModuleArgs.builder
import com.pulumi.azurenative.automation.kotlin.inputs.ContentLinkArgs
import com.pulumi.azurenative.automation.kotlin.inputs.ContentLinkArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of the module type.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update a module
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var module = new AzureNative.Automation.Module("module", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount33",
 *         ContentLink = new AzureNative.Automation.Inputs.ContentLinkArgs
 *         {
 *             ContentHash = new AzureNative.Automation.Inputs.ContentHashArgs
 *             {
 *                 Algorithm = "sha265",
 *                 Value = "07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A",
 *             },
 *             Uri = "https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip",
 *             Version = "1.0.0.0",
 *         },
 *         ModuleName = "OmsCompositeResources",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewModule(ctx, "module", &automation.ModuleArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount33"),
 * 			ContentLink: &automation.ContentLinkArgs{
 * 				ContentHash: &automation.ContentHashArgs{
 * 					Algorithm: pulumi.String("sha265"),
 * 					Value:     pulumi.String("07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A"),
 * 				},
 * 				Uri:     pulumi.String("https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip"),
 * 				Version: pulumi.String("1.0.0.0"),
 * 			},
 * 			ModuleName:        pulumi.String("OmsCompositeResources"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Module;
 * import com.pulumi.azurenative.automation.ModuleArgs;
 * import com.pulumi.azurenative.automation.inputs.ContentLinkArgs;
 * import com.pulumi.azurenative.automation.inputs.ContentHashArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var module = new Module("module", ModuleArgs.builder()
 *             .automationAccountName("myAutomationAccount33")
 *             .contentLink(ContentLinkArgs.builder()
 *                 .contentHash(ContentHashArgs.builder()
 *                     .algorithm("sha265")
 *                     .value("07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A")
 *                     .build())
 *                 .uri("https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip")
 *                 .version("1.0.0.0")
 *                 .build())
 *             .moduleName("OmsCompositeResources")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Module OmsCompositeResources /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/modules/{moduleName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property contentLink Gets or sets the module content link.
 * @property location Gets or sets the location of the resource.
 * @property moduleName The name of module.
 * @property name Gets or sets name of the resource.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property tags Gets or sets the tags attached to the resource.
 */
public data class ModuleArgs(
    public val automationAccountName: Output<String>? = null,
    public val contentLink: Output<ContentLinkArgs>? = null,
    public val location: Output<String>? = null,
    public val moduleName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.ModuleArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.ModuleArgs =
        com.pulumi.azurenative.automation.ModuleArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .contentLink(contentLink?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .moduleName(moduleName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ModuleArgs].
 */
@PulumiTagMarker
public class ModuleArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var contentLink: Output<ContentLinkArgs>? = null

    private var location: Output<String>? = null

    private var moduleName: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("rspdqtucjavbiwkf")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value Gets or sets the module content link.
     */
    @JvmName("tmqoyeprhklljsah")
    public suspend fun contentLink(`value`: Output<ContentLinkArgs>) {
        this.contentLink = value
    }

    /**
     * @param value Gets or sets the location of the resource.
     */
    @JvmName("hrhjdhamxkvicvts")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of module.
     */
    @JvmName("dvyssuolcbovcnyj")
    public suspend fun moduleName(`value`: Output<String>) {
        this.moduleName = value
    }

    /**
     * @param value Gets or sets name of the resource.
     */
    @JvmName("ssgptmqdgdiufodj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("jhrkddknoabnabwo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the tags attached to the resource.
     */
    @JvmName("ldvbfccusnxdfdlj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("aykloplyrddkdvip")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value Gets or sets the module content link.
     */
    @JvmName("jbfpdfmhsgjxyowp")
    public suspend fun contentLink(`value`: ContentLinkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentLink = mapped
    }

    /**
     * @param argument Gets or sets the module content link.
     */
    @JvmName("ecpeuwsrajmrydam")
    public suspend fun contentLink(argument: suspend ContentLinkArgsBuilder.() -> Unit) {
        val toBeMapped = ContentLinkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contentLink = mapped
    }

    /**
     * @param value Gets or sets the location of the resource.
     */
    @JvmName("hmrxsvuohdccncan")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of module.
     */
    @JvmName("lebbmjmvjrorskeg")
    public suspend fun moduleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.moduleName = mapped
    }

    /**
     * @param value Gets or sets name of the resource.
     */
    @JvmName("vdcokygchkyoqekp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("abffwxwqnswdbqmw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the tags attached to the resource.
     */
    @JvmName("iepieinfymyecjjt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the tags attached to the resource.
     */
    @JvmName("oajxkvlbtwqxdkfl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ModuleArgs = ModuleArgs(
        automationAccountName = automationAccountName,
        contentLink = contentLink,
        location = location,
        moduleName = moduleName,
        name = name,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
