@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.PowerShell72ModuleArgs.builder
import com.pulumi.azurenative.automation.kotlin.inputs.ContentLinkArgs
import com.pulumi.azurenative.automation.kotlin.inputs.ContentLinkArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of the module type.
 * Azure REST API version: 2023-11-01.
 * ## Example Usage
 * ### Create or update a module
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var powerShell72Module = new AzureNative.Automation.PowerShell72Module("powerShell72Module", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount33",
 *         ContentLink = new AzureNative.Automation.Inputs.ContentLinkArgs
 *         {
 *             ContentHash = new AzureNative.Automation.Inputs.ContentHashArgs
 *             {
 *                 Algorithm = "sha265",
 *                 Value = "07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87B",
 *             },
 *             Uri = "https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip",
 *             Version = "1.0.0.0",
 *         },
 *         ModuleName = "OmsCompositeResources",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewPowerShell72Module(ctx, "powerShell72Module", &automation.PowerShell72ModuleArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount33"),
 * 			ContentLink: &automation.ContentLinkArgs{
 * 				ContentHash: &automation.ContentHashArgs{
 * 					Algorithm: pulumi.String("sha265"),
 * 					Value:     pulumi.String("07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87B"),
 * 				},
 * 				Uri:     pulumi.String("https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip"),
 * 				Version: pulumi.String("1.0.0.0"),
 * 			},
 * 			ModuleName:        pulumi.String("OmsCompositeResources"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.PowerShell72Module;
 * import com.pulumi.azurenative.automation.PowerShell72ModuleArgs;
 * import com.pulumi.azurenative.automation.inputs.ContentLinkArgs;
 * import com.pulumi.azurenative.automation.inputs.ContentHashArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var powerShell72Module = new PowerShell72Module("powerShell72Module", PowerShell72ModuleArgs.builder()
 *             .automationAccountName("myAutomationAccount33")
 *             .contentLink(ContentLinkArgs.builder()
 *                 .contentHash(ContentHashArgs.builder()
 *                     .algorithm("sha265")
 *                     .value("07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87B")
 *                     .build())
 *                 .uri("https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip")
 *                 .version("1.0.0.0")
 *                 .build())
 *             .moduleName("OmsCompositeResources")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:PowerShell72Module OmsCompositeResources /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/powerShell72Modules/{moduleName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property contentLink Sets the hash.
 * @property location Sets the location of the resource.
 * @property moduleName The name of module.
 * @property name Sets name of the resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Sets the tags attached to the resource.
 */
public data class PowerShell72ModuleArgs(
    public val automationAccountName: Output<String>? = null,
    public val contentLink: Output<ContentLinkArgs>? = null,
    public val location: Output<String>? = null,
    public val moduleName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.PowerShell72ModuleArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.PowerShell72ModuleArgs =
        com.pulumi.azurenative.automation.PowerShell72ModuleArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .contentLink(contentLink?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .moduleName(moduleName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PowerShell72ModuleArgs].
 */
@PulumiTagMarker
public class PowerShell72ModuleArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var contentLink: Output<ContentLinkArgs>? = null

    private var location: Output<String>? = null

    private var moduleName: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("pbriemqjykylemtb")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value Sets the hash.
     */
    @JvmName("oigjweuxgxlxrjlv")
    public suspend fun contentLink(`value`: Output<ContentLinkArgs>) {
        this.contentLink = value
    }

    /**
     * @param value Sets the location of the resource.
     */
    @JvmName("tyxfqunrjgvqghlb")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of module.
     */
    @JvmName("mrkcofscspoekcqg")
    public suspend fun moduleName(`value`: Output<String>) {
        this.moduleName = value
    }

    /**
     * @param value Sets name of the resource.
     */
    @JvmName("fqqgfnobqldilfqw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dclaqapgiyckqlmo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Sets the tags attached to the resource.
     */
    @JvmName("wiomobrdkjxhspit")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("cquuvhlwtddilrcp")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value Sets the hash.
     */
    @JvmName("nbawhxraoancooal")
    public suspend fun contentLink(`value`: ContentLinkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentLink = mapped
    }

    /**
     * @param argument Sets the hash.
     */
    @JvmName("jjvnjvfaqoymreqi")
    public suspend fun contentLink(argument: suspend ContentLinkArgsBuilder.() -> Unit) {
        val toBeMapped = ContentLinkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contentLink = mapped
    }

    /**
     * @param value Sets the location of the resource.
     */
    @JvmName("bfnytehndvfwfrhi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of module.
     */
    @JvmName("hxbluvigyrgoyqvg")
    public suspend fun moduleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.moduleName = mapped
    }

    /**
     * @param value Sets name of the resource.
     */
    @JvmName("oofolqlnnnoiqeax")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jnblkbwujlilllmi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Sets the tags attached to the resource.
     */
    @JvmName("kqqibefrvelsdbcj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Sets the tags attached to the resource.
     */
    @JvmName("beautgiimrmamivb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PowerShell72ModuleArgs = PowerShell72ModuleArgs(
        automationAccountName = automationAccountName,
        contentLink = contentLink,
        location = location,
        moduleName = moduleName,
        name = name,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
