@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.RuntimeEnvironmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of the Runtime Environment type.
 * Azure REST API version: 2023-05-15-preview.
 * ## Example Usage
 * ### Create or update automation account
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var runtimeEnvironment = new AzureNative.Automation.RuntimeEnvironment("runtimeEnvironment", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount9",
 *         DefaultPackages =
 *         {
 *             { "Az", "8.3.0" },
 *         },
 *         Language = "PowerShell",
 *         Location = "East US 2",
 *         ResourceGroupName = "rg",
 *         RuntimeEnvironmentName = "myRuntimeEnvironmentName",
 *         Version = "7.1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewRuntimeEnvironment(ctx, "runtimeEnvironment", &automation.RuntimeEnvironmentArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount9"),
 * 			DefaultPackages: pulumi.StringMap{
 * 				"Az": pulumi.String("8.3.0"),
 * 			},
 * 			Language:               pulumi.String("PowerShell"),
 * 			Location:               pulumi.String("East US 2"),
 * 			ResourceGroupName:      pulumi.String("rg"),
 * 			RuntimeEnvironmentName: pulumi.String("myRuntimeEnvironmentName"),
 * 			Version:                pulumi.String("7.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.RuntimeEnvironment;
 * import com.pulumi.azurenative.automation.RuntimeEnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var runtimeEnvironment = new RuntimeEnvironment("runtimeEnvironment", RuntimeEnvironmentArgs.builder()
 *             .automationAccountName("myAutomationAccount9")
 *             .defaultPackages(Map.of("Az", "8.3.0"))
 *             .language("PowerShell")
 *             .location("East US 2")
 *             .resourceGroupName("rg")
 *             .runtimeEnvironmentName("myRuntimeEnvironmentName")
 *             .version("7.1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:RuntimeEnvironment myRuntimeEnvironmentName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runtimeEnvironments/{runtimeEnvironmentName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property defaultPackages List of Default packages for Environment
 * @property description Gets or sets the description.
 * @property language Language of Runtime Environment
 * @property location The geo-location where the resource lives
 * @property resourceGroupName Name of an Azure Resource group.
 * @property runtimeEnvironmentName The name of the Runtime Environment.
 * @property tags Resource tags.
 * @property version Version of Language
 */
public data class RuntimeEnvironmentArgs(
    public val automationAccountName: Output<String>? = null,
    public val defaultPackages: Output<Map<String, String>>? = null,
    public val description: Output<String>? = null,
    public val language: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val runtimeEnvironmentName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.RuntimeEnvironmentArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.RuntimeEnvironmentArgs =
        com.pulumi.azurenative.automation.RuntimeEnvironmentArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .defaultPackages(
                defaultPackages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .language(language?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .runtimeEnvironmentName(runtimeEnvironmentName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuntimeEnvironmentArgs].
 */
@PulumiTagMarker
public class RuntimeEnvironmentArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var defaultPackages: Output<Map<String, String>>? = null

    private var description: Output<String>? = null

    private var language: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var runtimeEnvironmentName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<String>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("lnlbeymxcknikxaq")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value List of Default packages for Environment
     */
    @JvmName("asycaueyparrspjl")
    public suspend fun defaultPackages(`value`: Output<Map<String, String>>) {
        this.defaultPackages = value
    }

    /**
     * @param value Gets or sets the description.
     */
    @JvmName("divfqpcvqkpqtucy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Language of Runtime Environment
     */
    @JvmName("ymoqpawsmarwtwos")
    public suspend fun language(`value`: Output<String>) {
        this.language = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("sbnnpfmogutfpfbx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("wslepsbrqaowufxc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Runtime Environment.
     */
    @JvmName("igdvnjbgdpsqyloh")
    public suspend fun runtimeEnvironmentName(`value`: Output<String>) {
        this.runtimeEnvironmentName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rdsvwmmhxpiffoog")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Version of Language
     */
    @JvmName("rssjpwggjpjtjljf")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("eirjlakothpockxb")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value List of Default packages for Environment
     */
    @JvmName("nxodwwqfxjtfikuv")
    public suspend fun defaultPackages(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultPackages = mapped
    }

    /**
     * @param values List of Default packages for Environment
     */
    @JvmName("rukmfggkokwdibsf")
    public fun defaultPackages(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultPackages = mapped
    }

    /**
     * @param value Gets or sets the description.
     */
    @JvmName("cqeytkechmhcmqke")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Language of Runtime Environment
     */
    @JvmName("hwldtrlgcrucrnsp")
    public suspend fun language(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.language = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("aopoctounpkwtsdt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("ktfydhxvnouoedio")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Runtime Environment.
     */
    @JvmName("qyqvvtojrworxids")
    public suspend fun runtimeEnvironmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeEnvironmentName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tvrecnpgyuqpmggc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tasnyucxkdpeymsj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Version of Language
     */
    @JvmName("vpecvqlfjpxofeub")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): RuntimeEnvironmentArgs = RuntimeEnvironmentArgs(
        automationAccountName = automationAccountName,
        defaultPackages = defaultPackages,
        description = description,
        language = language,
        location = location,
        resourceGroupName = resourceGroupName,
        runtimeEnvironmentName = runtimeEnvironmentName,
        tags = tags,
        version = version,
    )
}
