@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.SoftwareUpdateConfigurationByNameArgs.builder
import com.pulumi.azurenative.automation.kotlin.inputs.ErrorResponseArgs
import com.pulumi.azurenative.automation.kotlin.inputs.ErrorResponseArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.SUCSchedulePropertiesArgs
import com.pulumi.azurenative.automation.kotlin.inputs.SUCSchedulePropertiesArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.SoftwareUpdateConfigurationTasksArgs
import com.pulumi.azurenative.automation.kotlin.inputs.SoftwareUpdateConfigurationTasksArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.UpdateConfigurationArgs
import com.pulumi.azurenative.automation.kotlin.inputs.UpdateConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Software update configuration properties.
 * Azure REST API version: 2019-06-01. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2017-05-15-preview, 2023-05-15-preview.
 * ## Example Usage
 * ### Create software update configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var softwareUpdateConfigurationByName = new AzureNative.Automation.SoftwareUpdateConfigurationByName("softwareUpdateConfigurationByName", new()
 *     {
 *         AutomationAccountName = "myaccount",
 *         ResourceGroupName = "mygroup",
 *         ScheduleInfo = new AzureNative.Automation.Inputs.SUCSchedulePropertiesArgs
 *         {
 *             AdvancedSchedule = new AzureNative.Automation.Inputs.AdvancedScheduleArgs
 *             {
 *                 WeekDays = new[]
 *                 {
 *                     "Monday",
 *                     "Thursday",
 *                 },
 *             },
 *             ExpiryTime = "2018-11-09T11:22:57+00:00",
 *             Frequency = AzureNative.Automation.ScheduleFrequency.Hour,
 *             Interval = 1,
 *             StartTime = "2017-10-19T12:22:57+00:00",
 *             TimeZone = "America/Los_Angeles",
 *         },
 *         SoftwareUpdateConfigurationName = "testpatch",
 *         Tasks = new AzureNative.Automation.Inputs.SoftwareUpdateConfigurationTasksArgs
 *         {
 *             PostTask = new AzureNative.Automation.Inputs.TaskPropertiesArgs
 *             {
 *                 Source = "GetCache",
 *             },
 *             PreTask = new AzureNative.Automation.Inputs.TaskPropertiesArgs
 *             {
 *                 Parameters =
 *                 {
 *                     { "COMPUTERNAME", "Computer1" },
 *                 },
 *                 Source = "HelloWorld",
 *             },
 *         },
 *         UpdateConfiguration = new AzureNative.Automation.Inputs.UpdateConfigurationArgs
 *         {
 *             AzureVirtualMachines = new[]
 *             {
 *                 "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-01",
 *                 "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-02",
 *                 "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-03",
 *             },
 *             Duration = "PT2H0M",
 *             NonAzureComputerNames = new[]
 *             {
 *                 "box1.contoso.com",
 *                 "box2.contoso.com",
 *             },
 *             OperatingSystem = AzureNative.Automation.OperatingSystemType.Windows,
 *             Targets = new AzureNative.Automation.Inputs.TargetPropertiesArgs
 *             {
 *                 AzureQueries = new[]
 *                 {
 *                     new AzureNative.Automation.Inputs.AzureQueryPropertiesArgs
 *                     {
 *                         Locations = new[]
 *                         {
 *                             "Japan East",
 *                             "UK South",
 *                         },
 *                         Scope = new[]
 *                         {
 *                             "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources",
 *                             "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067",
 *                         },
 *                         TagSettings = new AzureNative.Automation.Inputs.TagSettingsPropertiesArgs
 *                         {
 *                             FilterOperator = AzureNative.Automation.TagOperators.All,
 *                             Tags =
 *                             {
 *                                 { "tag1", new[]
 *                                 {
 *                                     "tag1Value1",
 *                                     "tag1Value2",
 *                                     "tag1Value3",
 *                                 } },
 *                                 { "tag2", new[]
 *                                 {
 *                                     "tag2Value1",
 *                                     "tag2Value2",
 *                                     "tag2Value3",
 *                                 } },
 *                             },
 *                         },
 *                     },
 *                 },
 *                 NonAzureQueries = new[]
 *                 {
 *                     new AzureNative.Automation.Inputs.NonAzureQueryPropertiesArgs
 *                     {
 *                         FunctionAlias = "SavedSearch1",
 *                         WorkspaceId = "WorkspaceId1",
 *                     },
 *                     new AzureNative.Automation.Inputs.NonAzureQueryPropertiesArgs
 *                     {
 *                         FunctionAlias = "SavedSearch2",
 *                         WorkspaceId = "WorkspaceId2",
 *                     },
 *                 },
 *             },
 *             Windows = new AzureNative.Automation.Inputs.WindowsPropertiesArgs
 *             {
 *                 ExcludedKbNumbers = new[]
 *                 {
 *                     "168934",
 *                     "168973",
 *                 },
 *                 IncludedUpdateClassifications = AzureNative.Automation.WindowsUpdateClasses.Critical,
 *                 RebootSetting = "IfRequired",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewSoftwareUpdateConfigurationByName(ctx, "softwareUpdateConfigurationByName", &automation.SoftwareUpdateConfigurationByNameArgs{
 * 			AutomationAccountName: pulumi.String("myaccount"),
 * 			ResourceGroupName:     pulumi.String("mygroup"),
 * 			ScheduleInfo: &automation.SUCSchedulePropertiesArgs{
 * 				AdvancedSchedule: &automation.AdvancedScheduleArgs{
 * 					WeekDays: pulumi.StringArray{
 * 						pulumi.String("Monday"),
 * 						pulumi.String("Thursday"),
 * 					},
 * 				},
 * 				ExpiryTime: pulumi.String("2018-11-09T11:22:57+00:00"),
 * 				Frequency:  pulumi.String(automation.ScheduleFrequencyHour),
 * 				Interval:   pulumi.Float64(1),
 * 				StartTime:  pulumi.String("2017-10-19T12:22:57+00:00"),
 * 				TimeZone:   pulumi.String("America/Los_Angeles"),
 * 			},
 * 			SoftwareUpdateConfigurationName: pulumi.String("testpatch"),
 * 			Tasks: &automation.SoftwareUpdateConfigurationTasksArgs{
 * 				PostTask: &automation.TaskPropertiesArgs{
 * 					Source: pulumi.String("GetCache"),
 * 				},
 * 				PreTask: &automation.TaskPropertiesArgs{
 * 					Parameters: pulumi.StringMap{
 * 						"COMPUTERNAME": pulumi.String("Computer1"),
 * 					},
 * 					Source: pulumi.String("HelloWorld"),
 * 				},
 * 			},
 * 			UpdateConfiguration: &automation.UpdateConfigurationArgs{
 * 				AzureVirtualMachines: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-01"),
 * 					pulumi.String("/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-02"),
 * 					pulumi.String("/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-03"),
 * 				},
 * 				Duration: pulumi.String("PT2H0M"),
 * 				NonAzureComputerNames: pulumi.StringArray{
 * 					pulumi.String("box1.contoso.com"),
 * 					pulumi.String("box2.contoso.com"),
 * 				},
 * 				OperatingSystem: automation.OperatingSystemTypeWindows,
 * 				Targets: &automation.TargetPropertiesArgs{
 * 					AzureQueries: automation.AzureQueryPropertiesArray{
 * 						&automation.AzureQueryPropertiesArgs{
 * 							Locations: pulumi.StringArray{
 * 								pulumi.String("Japan East"),
 * 								pulumi.String("UK South"),
 * 							},
 * 							Scope: pulumi.StringArray{
 * 								pulumi.String("/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources"),
 * 								pulumi.String("/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067"),
 * 							},
 * 							TagSettings: &automation.TagSettingsPropertiesArgs{
 * 								FilterOperator: automation.TagOperatorsAll,
 * 								Tags: pulumi.StringArrayMap{
 * 									"tag1": pulumi.StringArray{
 * 										pulumi.String("tag1Value1"),
 * 										pulumi.String("tag1Value2"),
 * 										pulumi.String("tag1Value3"),
 * 									},
 * 									"tag2": pulumi.StringArray{
 * 										pulumi.String("tag2Value1"),
 * 										pulumi.String("tag2Value2"),
 * 										pulumi.String("tag2Value3"),
 * 									},
 * 								},
 * 							},
 * 						},
 * 					},
 * 					NonAzureQueries: automation.NonAzureQueryPropertiesArray{
 * 						&automation.NonAzureQueryPropertiesArgs{
 * 							FunctionAlias: pulumi.String("SavedSearch1"),
 * 							WorkspaceId:   pulumi.String("WorkspaceId1"),
 * 						},
 * 						&automation.NonAzureQueryPropertiesArgs{
 * 							FunctionAlias: pulumi.String("SavedSearch2"),
 * 							WorkspaceId:   pulumi.String("WorkspaceId2"),
 * 						},
 * 					},
 * 				},
 * 				Windows: &automation.WindowsPropertiesArgs{
 * 					ExcludedKbNumbers: pulumi.StringArray{
 * 						pulumi.String("168934"),
 * 						pulumi.String("168973"),
 * 					},
 * 					IncludedUpdateClassifications: pulumi.String(automation.WindowsUpdateClassesCritical),
 * 					RebootSetting:                 pulumi.String("IfRequired"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.SoftwareUpdateConfigurationByName;
 * import com.pulumi.azurenative.automation.SoftwareUpdateConfigurationByNameArgs;
 * import com.pulumi.azurenative.automation.inputs.SUCSchedulePropertiesArgs;
 * import com.pulumi.azurenative.automation.inputs.AdvancedScheduleArgs;
 * import com.pulumi.azurenative.automation.inputs.SoftwareUpdateConfigurationTasksArgs;
 * import com.pulumi.azurenative.automation.inputs.TaskPropertiesArgs;
 * import com.pulumi.azurenative.automation.inputs.UpdateConfigurationArgs;
 * import com.pulumi.azurenative.automation.inputs.TargetPropertiesArgs;
 * import com.pulumi.azurenative.automation.inputs.WindowsPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var softwareUpdateConfigurationByName = new SoftwareUpdateConfigurationByName("softwareUpdateConfigurationByName", SoftwareUpdateConfigurationByNameArgs.builder()
 *             .automationAccountName("myaccount")
 *             .resourceGroupName("mygroup")
 *             .scheduleInfo(SUCSchedulePropertiesArgs.builder()
 *                 .advancedSchedule(AdvancedScheduleArgs.builder()
 *                     .weekDays(
 *                         "Monday",
 *                         "Thursday")
 *                     .build())
 *                 .expiryTime("2018-11-09T11:22:57+00:00")
 *                 .frequency("Hour")
 *                 .interval(1)
 *                 .startTime("2017-10-19T12:22:57+00:00")
 *                 .timeZone("America/Los_Angeles")
 *                 .build())
 *             .softwareUpdateConfigurationName("testpatch")
 *             .tasks(SoftwareUpdateConfigurationTasksArgs.builder()
 *                 .postTask(TaskPropertiesArgs.builder()
 *                     .source("GetCache")
 *                     .build())
 *                 .preTask(TaskPropertiesArgs.builder()
 *                     .parameters(Map.of("COMPUTERNAME", "Computer1"))
 *                     .source("HelloWorld")
 *                     .build())
 *                 .build())
 *             .updateConfiguration(UpdateConfigurationArgs.builder()
 *                 .azureVirtualMachines(
 *                     "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-01",
 *                     "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-02",
 *                     "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-03")
 *                 .duration("PT2H0M")
 *                 .nonAzureComputerNames(
 *                     "box1.contoso.com",
 *                     "box2.contoso.com")
 *                 .operatingSystem("Windows")
 *                 .targets(TargetPropertiesArgs.builder()
 *                     .azureQueries(AzureQueryPropertiesArgs.builder()
 *                         .locations(
 *                             "Japan East",
 *                             "UK South")
 *                         .scope(
 *                             "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources",
 *                             "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067")
 *                         .tagSettings(TagSettingsPropertiesArgs.builder()
 *                             .filterOperator("All")
 *                             .tags(Map.ofEntries(
 *                                 Map.entry("tag1",
 *                                     "tag1Value1",
 *                                     "tag1Value2",
 *                                     "tag1Value3"),
 *                                 Map.entry("tag2",
 *                                     "tag2Value1",
 *                                     "tag2Value2",
 *                                     "tag2Value3")
 *                             ))
 *                             .build())
 *                         .build())
 *                     .nonAzureQueries(
 *                         NonAzureQueryPropertiesArgs.builder()
 *                             .functionAlias("SavedSearch1")
 *                             .workspaceId("WorkspaceId1")
 *                             .build(),
 *                         NonAzureQueryPropertiesArgs.builder()
 *                             .functionAlias("SavedSearch2")
 *                             .workspaceId("WorkspaceId2")
 *                             .build())
 *                     .build())
 *                 .windows(WindowsPropertiesArgs.builder()
 *                     .excludedKbNumbers(
 *                         "168934",
 *                         "168973")
 *                     .includedUpdateClassifications("Critical")
 *                     .rebootSetting("IfRequired")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:SoftwareUpdateConfigurationByName testpatch /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/softwareUpdateConfigurations/{softwareUpdateConfigurationName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property error Details of provisioning error
 * @property resourceGroupName Name of an Azure Resource group.
 * @property scheduleInfo Schedule information for the Software update configuration
 * @property softwareUpdateConfigurationName The name of the software update configuration to be created.
 * @property tasks Tasks information for the Software update configuration.
 * @property updateConfiguration update specific properties for the Software update configuration
 */
public data class SoftwareUpdateConfigurationByNameArgs(
    public val automationAccountName: Output<String>? = null,
    public val error: Output<ErrorResponseArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scheduleInfo: Output<SUCSchedulePropertiesArgs>? = null,
    public val softwareUpdateConfigurationName: Output<String>? = null,
    public val tasks: Output<SoftwareUpdateConfigurationTasksArgs>? = null,
    public val updateConfiguration: Output<UpdateConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.SoftwareUpdateConfigurationByNameArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.SoftwareUpdateConfigurationByNameArgs =
        com.pulumi.azurenative.automation.SoftwareUpdateConfigurationByNameArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .error(error?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scheduleInfo(scheduleInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .softwareUpdateConfigurationName(softwareUpdateConfigurationName?.applyValue({ args0 -> args0 }))
            .tasks(tasks?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .updateConfiguration(
                updateConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SoftwareUpdateConfigurationByNameArgs].
 */
@PulumiTagMarker
public class SoftwareUpdateConfigurationByNameArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var error: Output<ErrorResponseArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var scheduleInfo: Output<SUCSchedulePropertiesArgs>? = null

    private var softwareUpdateConfigurationName: Output<String>? = null

    private var tasks: Output<SoftwareUpdateConfigurationTasksArgs>? = null

    private var updateConfiguration: Output<UpdateConfigurationArgs>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("eiqsgtupupbwrkvb")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value Details of provisioning error
     */
    @JvmName("ermflbxbbljrwssy")
    public suspend fun error(`value`: Output<ErrorResponseArgs>) {
        this.error = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("hhdyuhcijaywpsnn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Schedule information for the Software update configuration
     */
    @JvmName("dnmbqxlfcgwcilio")
    public suspend fun scheduleInfo(`value`: Output<SUCSchedulePropertiesArgs>) {
        this.scheduleInfo = value
    }

    /**
     * @param value The name of the software update configuration to be created.
     */
    @JvmName("ichibokacybplfxt")
    public suspend fun softwareUpdateConfigurationName(`value`: Output<String>) {
        this.softwareUpdateConfigurationName = value
    }

    /**
     * @param value Tasks information for the Software update configuration.
     */
    @JvmName("bedkvgjdtlcocoob")
    public suspend fun tasks(`value`: Output<SoftwareUpdateConfigurationTasksArgs>) {
        this.tasks = value
    }

    /**
     * @param value update specific properties for the Software update configuration
     */
    @JvmName("fohvxmmwvllcoqsy")
    public suspend fun updateConfiguration(`value`: Output<UpdateConfigurationArgs>) {
        this.updateConfiguration = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("qutyghwcljjhwgjr")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value Details of provisioning error
     */
    @JvmName("tjpbgrtwklxqajbl")
    public suspend fun error(`value`: ErrorResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.error = mapped
    }

    /**
     * @param argument Details of provisioning error
     */
    @JvmName("fwcfeirmhuukuqtc")
    public suspend fun error(argument: suspend ErrorResponseArgsBuilder.() -> Unit) {
        val toBeMapped = ErrorResponseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.error = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("skvwjkswmyuuosqb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Schedule information for the Software update configuration
     */
    @JvmName("sbapvtejqefgrgti")
    public suspend fun scheduleInfo(`value`: SUCSchedulePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleInfo = mapped
    }

    /**
     * @param argument Schedule information for the Software update configuration
     */
    @JvmName("opdlrrflfydfasib")
    public suspend fun scheduleInfo(argument: suspend SUCSchedulePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SUCSchedulePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scheduleInfo = mapped
    }

    /**
     * @param value The name of the software update configuration to be created.
     */
    @JvmName("vjhpysmusvjufoba")
    public suspend fun softwareUpdateConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softwareUpdateConfigurationName = mapped
    }

    /**
     * @param value Tasks information for the Software update configuration.
     */
    @JvmName("vqyhkxhxakoivyro")
    public suspend fun tasks(`value`: SoftwareUpdateConfigurationTasksArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tasks = mapped
    }

    /**
     * @param argument Tasks information for the Software update configuration.
     */
    @JvmName("xrkjfxoiwauglusn")
    public suspend fun tasks(argument: suspend SoftwareUpdateConfigurationTasksArgsBuilder.() -> Unit) {
        val toBeMapped = SoftwareUpdateConfigurationTasksArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tasks = mapped
    }

    /**
     * @param value update specific properties for the Software update configuration
     */
    @JvmName("voejannaobexykek")
    public suspend fun updateConfiguration(`value`: UpdateConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateConfiguration = mapped
    }

    /**
     * @param argument update specific properties for the Software update configuration
     */
    @JvmName("kjhmcroxqkeuqyuk")
    public suspend fun updateConfiguration(argument: suspend UpdateConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = UpdateConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.updateConfiguration = mapped
    }

    internal fun build(): SoftwareUpdateConfigurationByNameArgs =
        SoftwareUpdateConfigurationByNameArgs(
            automationAccountName = automationAccountName,
            error = error,
            resourceGroupName = resourceGroupName,
            scheduleInfo = scheduleInfo,
            softwareUpdateConfigurationName = softwareUpdateConfigurationName,
            tasks = tasks,
            updateConfiguration = updateConfiguration,
        )
}
