@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The identity type.
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.automation.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.automation.enums.ResourceIdentityType> {
    SystemAssigned(com.pulumi.azurenative.automation.enums.ResourceIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.automation.enums.ResourceIdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.automation.enums.ResourceIdentityType.SystemAssigned_UserAssigned),
    None(com.pulumi.azurenative.automation.enums.ResourceIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.automation.enums.ResourceIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.enums.ResourceIdentityType): ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
