@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.EncryptionPropertiesIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * User identity used for CMK.
 * @property userAssignedIdentity The user identity used for CMK. It will be an ARM resource id in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
 */
public data class EncryptionPropertiesIdentityArgs(
    public val userAssignedIdentity: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.EncryptionPropertiesIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.EncryptionPropertiesIdentityArgs =
        com.pulumi.azurenative.automation.inputs.EncryptionPropertiesIdentityArgs.builder()
            .userAssignedIdentity(userAssignedIdentity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionPropertiesIdentityArgs].
 */
@PulumiTagMarker
public class EncryptionPropertiesIdentityArgsBuilder internal constructor() {
    private var userAssignedIdentity: Output<Any>? = null

    /**
     * @param value The user identity used for CMK. It will be an ARM resource id in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("cfgunrehgcudtmnp")
    public suspend fun userAssignedIdentity(`value`: Output<Any>) {
        this.userAssignedIdentity = value
    }

    /**
     * @param value The user identity used for CMK. It will be an ARM resource id in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("itswppuvkdhbrpex")
    public suspend fun userAssignedIdentity(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentity = mapped
    }

    internal fun build(): EncryptionPropertiesIdentityArgs = EncryptionPropertiesIdentityArgs(
        userAssignedIdentity = userAssignedIdentity,
    )
}
