@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.ErrorResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Error response of an operation failure
 * @property code Error code
 * @property message Error message indicating why the operation failed.
 */
public data class ErrorResponseArgs(
    public val code: Output<String>? = null,
    public val message: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.ErrorResponseArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.ErrorResponseArgs =
        com.pulumi.azurenative.automation.inputs.ErrorResponseArgs.builder()
            .code(code?.applyValue({ args0 -> args0 }))
            .message(message?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ErrorResponseArgs].
 */
@PulumiTagMarker
public class ErrorResponseArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    private var message: Output<String>? = null

    /**
     * @param value Error code
     */
    @JvmName("lniaktjkdomtpykv")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value Error message indicating why the operation failed.
     */
    @JvmName("wvhoipvtsrcphoxw")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value Error code
     */
    @JvmName("bunqrxkvigwjsjef")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Error message indicating why the operation failed.
     */
    @JvmName("luidmpesbuoguxho")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    internal fun build(): ErrorResponseArgs = ErrorResponseArgs(
        code = code,
        message = message,
    )
}
