@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetConnectionTypePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property connectionTypeName The name of connection type.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class GetConnectionTypePlainArgs(
    public val automationAccountName: String,
    public val connectionTypeName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetConnectionTypePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.GetConnectionTypePlainArgs =
        com.pulumi.azurenative.automation.inputs.GetConnectionTypePlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .connectionTypeName(connectionTypeName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectionTypePlainArgs].
 */
@PulumiTagMarker
public class GetConnectionTypePlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var connectionTypeName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("xjgwwnmhioclrehe")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value The name of connection type.
     */
    @JvmName("whafutaortnvbgjw")
    public suspend fun connectionTypeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionTypeName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("wrjwatvklajxfnkg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConnectionTypePlainArgs = GetConnectionTypePlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        connectionTypeName = connectionTypeName ?: throw PulumiNullFieldException("connectionTypeName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
