@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.PrivateLinkServiceConnectionStatePropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Connection State of the Private Endpoint Connection.
 * @property description The private link service connection description.
 * @property status The private link service connection status.
 */
public data class PrivateLinkServiceConnectionStatePropertyArgs(
    public val description: Output<String>? = null,
    public val status: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.automation.inputs.PrivateLinkServiceConnectionStatePropertyArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.PrivateLinkServiceConnectionStatePropertyArgs =
        com.pulumi.azurenative.automation.inputs.PrivateLinkServiceConnectionStatePropertyArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateLinkServiceConnectionStatePropertyArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceConnectionStatePropertyArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The private link service connection description.
     */
    @JvmName("tluhqgtbjxfdcgsd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("byqriyictuesckog")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The private link service connection description.
     */
    @JvmName("sdvvhtxmjohfhpuv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("juwcrkedhraffbem")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PrivateLinkServiceConnectionStatePropertyArgs =
        PrivateLinkServiceConnectionStatePropertyArgs(
            description = description,
            status = status,
        )
}
