@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.RunbookAssociationPropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The runbook property associated with the entity.
 * @property name Gets or sets the name of the runbook.
 */
public data class RunbookAssociationPropertyArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.RunbookAssociationPropertyArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.RunbookAssociationPropertyArgs =
        com.pulumi.azurenative.automation.inputs.RunbookAssociationPropertyArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RunbookAssociationPropertyArgs].
 */
@PulumiTagMarker
public class RunbookAssociationPropertyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Gets or sets the name of the runbook.
     */
    @JvmName("tlmheksghcovfhlf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the name of the runbook.
     */
    @JvmName("betvxmcwopopqlvw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): RunbookAssociationPropertyArgs = RunbookAssociationPropertyArgs(
        name = name,
    )
}
