@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.RunbookDraftArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property creationTime Gets or sets the creation time of the runbook draft.
 * @property draftContentLink Gets or sets the draft runbook content link.
 * @property inEdit Gets or sets whether runbook is in edit mode.
 * @property lastModifiedTime Gets or sets the last modified time of the runbook draft.
 * @property outputTypes Gets or sets the runbook output types.
 * @property parameters Gets or sets the runbook draft parameters.
 */
public data class RunbookDraftArgs(
    public val creationTime: Output<String>? = null,
    public val draftContentLink: Output<ContentLinkArgs>? = null,
    public val inEdit: Output<Boolean>? = null,
    public val lastModifiedTime: Output<String>? = null,
    public val outputTypes: Output<List<String>>? = null,
    public val parameters: Output<Map<String, RunbookParameterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.RunbookDraftArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.RunbookDraftArgs =
        com.pulumi.azurenative.automation.inputs.RunbookDraftArgs.builder()
            .creationTime(creationTime?.applyValue({ args0 -> args0 }))
            .draftContentLink(draftContentLink?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inEdit(inEdit?.applyValue({ args0 -> args0 }))
            .lastModifiedTime(lastModifiedTime?.applyValue({ args0 -> args0 }))
            .outputTypes(outputTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RunbookDraftArgs].
 */
@PulumiTagMarker
public class RunbookDraftArgsBuilder internal constructor() {
    private var creationTime: Output<String>? = null

    private var draftContentLink: Output<ContentLinkArgs>? = null

    private var inEdit: Output<Boolean>? = null

    private var lastModifiedTime: Output<String>? = null

    private var outputTypes: Output<List<String>>? = null

    private var parameters: Output<Map<String, RunbookParameterArgs>>? = null

    /**
     * @param value Gets or sets the creation time of the runbook draft.
     */
    @JvmName("alhfplgbnxeyafty")
    public suspend fun creationTime(`value`: Output<String>) {
        this.creationTime = value
    }

    /**
     * @param value Gets or sets the draft runbook content link.
     */
    @JvmName("xdyjbmwsitxjbxnw")
    public suspend fun draftContentLink(`value`: Output<ContentLinkArgs>) {
        this.draftContentLink = value
    }

    /**
     * @param value Gets or sets whether runbook is in edit mode.
     */
    @JvmName("wnqqigovxnjcneoj")
    public suspend fun inEdit(`value`: Output<Boolean>) {
        this.inEdit = value
    }

    /**
     * @param value Gets or sets the last modified time of the runbook draft.
     */
    @JvmName("xdxhatoignofbdev")
    public suspend fun lastModifiedTime(`value`: Output<String>) {
        this.lastModifiedTime = value
    }

    /**
     * @param value Gets or sets the runbook output types.
     */
    @JvmName("qgqgclbfxoourenq")
    public suspend fun outputTypes(`value`: Output<List<String>>) {
        this.outputTypes = value
    }

    @JvmName("tagckmlyuihkewgi")
    public suspend fun outputTypes(vararg values: Output<String>) {
        this.outputTypes = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the runbook output types.
     */
    @JvmName("fwjgmybpcvpxoifl")
    public suspend fun outputTypes(values: List<Output<String>>) {
        this.outputTypes = Output.all(values)
    }

    /**
     * @param value Gets or sets the runbook draft parameters.
     */
    @JvmName("nnlndccjkkfvatge")
    public suspend fun parameters(`value`: Output<Map<String, RunbookParameterArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Gets or sets the creation time of the runbook draft.
     */
    @JvmName("cfvkhlufcgaihdwe")
    public suspend fun creationTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationTime = mapped
    }

    /**
     * @param value Gets or sets the draft runbook content link.
     */
    @JvmName("wiiossfgadgybfsf")
    public suspend fun draftContentLink(`value`: ContentLinkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.draftContentLink = mapped
    }

    /**
     * @param argument Gets or sets the draft runbook content link.
     */
    @JvmName("whlikenntjemlfyo")
    public suspend fun draftContentLink(argument: suspend ContentLinkArgsBuilder.() -> Unit) {
        val toBeMapped = ContentLinkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.draftContentLink = mapped
    }

    /**
     * @param value Gets or sets whether runbook is in edit mode.
     */
    @JvmName("cynrgutqnsefxhwp")
    public suspend fun inEdit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inEdit = mapped
    }

    /**
     * @param value Gets or sets the last modified time of the runbook draft.
     */
    @JvmName("pkgrmcgjcpypmeox")
    public suspend fun lastModifiedTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastModifiedTime = mapped
    }

    /**
     * @param value Gets or sets the runbook output types.
     */
    @JvmName("bmgmhmsaawyfaefp")
    public suspend fun outputTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputTypes = mapped
    }

    /**
     * @param values Gets or sets the runbook output types.
     */
    @JvmName("eokhdvwiyivucdwm")
    public suspend fun outputTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputTypes = mapped
    }

    /**
     * @param value Gets or sets the runbook draft parameters.
     */
    @JvmName("gdvcwkfcmtdsjbmc")
    public suspend fun parameters(`value`: Map<String, RunbookParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Gets or sets the runbook draft parameters.
     */
    @JvmName("tymkkmtohifaqfqw")
    public suspend fun parameters(vararg argument: Pair<String, suspend RunbookParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                RunbookParameterArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Gets or sets the runbook draft parameters.
     */
    @JvmName("pcbjvxybfksoslpq")
    public fun parameters(vararg values: Pair<String, RunbookParameterArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    internal fun build(): RunbookDraftArgs = RunbookDraftArgs(
        creationTime = creationTime,
        draftContentLink = draftContentLink,
        inEdit = inEdit,
        lastModifiedTime = lastModifiedTime,
        outputTypes = outputTypes,
        parameters = parameters,
    )
}
