@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.TagSettingsPropertiesArgs.builder
import com.pulumi.azurenative.automation.kotlin.enums.TagOperators
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Tag filter information for the VM.
 * @property filterOperator Filter VMs by Any or All specified tags.
 * @property tags Dictionary of tags with its list of values.
 */
public data class TagSettingsPropertiesArgs(
    public val filterOperator: Output<TagOperators>? = null,
    public val tags: Output<Map<String, List<String>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.TagSettingsPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.TagSettingsPropertiesArgs =
        com.pulumi.azurenative.automation.inputs.TagSettingsPropertiesArgs.builder()
            .filterOperator(filterOperator?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.map({ args0 ->
                                args0
                            }),
                        )
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [TagSettingsPropertiesArgs].
 */
@PulumiTagMarker
public class TagSettingsPropertiesArgsBuilder internal constructor() {
    private var filterOperator: Output<TagOperators>? = null

    private var tags: Output<Map<String, List<String>>>? = null

    /**
     * @param value Filter VMs by Any or All specified tags.
     */
    @JvmName("hpvgnmtawketcmqr")
    public suspend fun filterOperator(`value`: Output<TagOperators>) {
        this.filterOperator = value
    }

    /**
     * @param value Dictionary of tags with its list of values.
     */
    @JvmName("dxfrnegnliqqxlji")
    public suspend fun tags(`value`: Output<Map<String, List<String>>>) {
        this.tags = value
    }

    /**
     * @param value Filter VMs by Any or All specified tags.
     */
    @JvmName("igmkjlaciquikwak")
    public suspend fun filterOperator(`value`: TagOperators?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterOperator = mapped
    }

    /**
     * @param value Dictionary of tags with its list of values.
     */
    @JvmName("nvbyauynxkvqafrj")
    public suspend fun tags(`value`: Map<String, List<String>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Dictionary of tags with its list of values.
     */
    @JvmName("dpoxbowawhfpywro")
    public fun tags(vararg values: Pair<String, List<String>>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): TagSettingsPropertiesArgs = TagSettingsPropertiesArgs(
        filterOperator = filterOperator,
        tags = tags,
    )
}
