@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.TargetPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Group specific to the update configuration.
 * @property azureQueries List of Azure queries in the software update configuration.
 * @property nonAzureQueries List of non Azure queries in the software update configuration.
 */
public data class TargetPropertiesArgs(
    public val azureQueries: Output<List<AzureQueryPropertiesArgs>>? = null,
    public val nonAzureQueries: Output<List<NonAzureQueryPropertiesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.TargetPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.TargetPropertiesArgs =
        com.pulumi.azurenative.automation.inputs.TargetPropertiesArgs.builder()
            .azureQueries(
                azureQueries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .nonAzureQueries(
                nonAzureQueries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TargetPropertiesArgs].
 */
@PulumiTagMarker
public class TargetPropertiesArgsBuilder internal constructor() {
    private var azureQueries: Output<List<AzureQueryPropertiesArgs>>? = null

    private var nonAzureQueries: Output<List<NonAzureQueryPropertiesArgs>>? = null

    /**
     * @param value List of Azure queries in the software update configuration.
     */
    @JvmName("weyprtvkaoqlkwjt")
    public suspend fun azureQueries(`value`: Output<List<AzureQueryPropertiesArgs>>) {
        this.azureQueries = value
    }

    @JvmName("odpuurgbfyclmhlo")
    public suspend fun azureQueries(vararg values: Output<AzureQueryPropertiesArgs>) {
        this.azureQueries = Output.all(values.asList())
    }

    /**
     * @param values List of Azure queries in the software update configuration.
     */
    @JvmName("jqxdqcgirocfeldu")
    public suspend fun azureQueries(values: List<Output<AzureQueryPropertiesArgs>>) {
        this.azureQueries = Output.all(values)
    }

    /**
     * @param value List of non Azure queries in the software update configuration.
     */
    @JvmName("txekypblehcmousv")
    public suspend fun nonAzureQueries(`value`: Output<List<NonAzureQueryPropertiesArgs>>) {
        this.nonAzureQueries = value
    }

    @JvmName("qvsjphifmhdaqait")
    public suspend fun nonAzureQueries(vararg values: Output<NonAzureQueryPropertiesArgs>) {
        this.nonAzureQueries = Output.all(values.asList())
    }

    /**
     * @param values List of non Azure queries in the software update configuration.
     */
    @JvmName("vhaaasjgodqswmjs")
    public suspend fun nonAzureQueries(values: List<Output<NonAzureQueryPropertiesArgs>>) {
        this.nonAzureQueries = Output.all(values)
    }

    /**
     * @param value List of Azure queries in the software update configuration.
     */
    @JvmName("oeftxhaksspjdnwa")
    public suspend fun azureQueries(`value`: List<AzureQueryPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureQueries = mapped
    }

    /**
     * @param argument List of Azure queries in the software update configuration.
     */
    @JvmName("doydxyvparferwuk")
    public suspend fun azureQueries(argument: List<suspend AzureQueryPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureQueryPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.azureQueries = mapped
    }

    /**
     * @param argument List of Azure queries in the software update configuration.
     */
    @JvmName("wtkuwrubrsjlyacp")
    public suspend fun azureQueries(vararg argument: suspend AzureQueryPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AzureQueryPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.azureQueries = mapped
    }

    /**
     * @param argument List of Azure queries in the software update configuration.
     */
    @JvmName("clxuxkphauonxpun")
    public suspend fun azureQueries(argument: suspend AzureQueryPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AzureQueryPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.azureQueries = mapped
    }

    /**
     * @param values List of Azure queries in the software update configuration.
     */
    @JvmName("trxlvmrldftdyiaf")
    public suspend fun azureQueries(vararg values: AzureQueryPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureQueries = mapped
    }

    /**
     * @param value List of non Azure queries in the software update configuration.
     */
    @JvmName("vxcplfkeicyjuwkp")
    public suspend fun nonAzureQueries(`value`: List<NonAzureQueryPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nonAzureQueries = mapped
    }

    /**
     * @param argument List of non Azure queries in the software update configuration.
     */
    @JvmName("bqipucfrsjahwmst")
    public suspend fun nonAzureQueries(argument: List<suspend NonAzureQueryPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NonAzureQueryPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nonAzureQueries = mapped
    }

    /**
     * @param argument List of non Azure queries in the software update configuration.
     */
    @JvmName("ymimomvqgqrmykfg")
    public suspend fun nonAzureQueries(vararg argument: suspend NonAzureQueryPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NonAzureQueryPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nonAzureQueries = mapped
    }

    /**
     * @param argument List of non Azure queries in the software update configuration.
     */
    @JvmName("fcmjbfnwkadhgfgh")
    public suspend fun nonAzureQueries(argument: suspend NonAzureQueryPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NonAzureQueryPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.nonAzureQueries = mapped
    }

    /**
     * @param values List of non Azure queries in the software update configuration.
     */
    @JvmName("jpcuinvjfgmeerrq")
    public suspend fun nonAzureQueries(vararg values: NonAzureQueryPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nonAzureQueries = mapped
    }

    internal fun build(): TargetPropertiesArgs = TargetPropertiesArgs(
        azureQueries = azureQueries,
        nonAzureQueries = nonAzureQueries,
    )
}
