@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.UpdateConfigurationArgs.builder
import com.pulumi.azurenative.automation.kotlin.enums.OperatingSystemType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Update specific properties of the software update configuration.
 * @property azureVirtualMachines List of azure resource Ids for azure virtual machines targeted by the software update configuration.
 * @property duration Maximum time allowed for the software update configuration run. Duration needs to be specified using the format PT[n]H[n]M[n]S as per ISO8601
 * @property linux Linux specific update configuration.
 * @property nonAzureComputerNames List of names of non-azure machines targeted by the software update configuration.
 * @property operatingSystem operating system of target machines
 * @property targets Group targets for the software update configuration.
 * @property windows Windows specific update configuration.
 */
public data class UpdateConfigurationArgs(
    public val azureVirtualMachines: Output<List<String>>? = null,
    public val duration: Output<String>? = null,
    public val linux: Output<LinuxPropertiesArgs>? = null,
    public val nonAzureComputerNames: Output<List<String>>? = null,
    public val operatingSystem: Output<OperatingSystemType>,
    public val targets: Output<TargetPropertiesArgs>? = null,
    public val windows: Output<WindowsPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.UpdateConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.UpdateConfigurationArgs =
        com.pulumi.azurenative.automation.inputs.UpdateConfigurationArgs.builder()
            .azureVirtualMachines(azureVirtualMachines?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .duration(duration?.applyValue({ args0 -> args0 }))
            .linux(linux?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nonAzureComputerNames(nonAzureComputerNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .operatingSystem(operatingSystem.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targets(targets?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .windows(windows?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [UpdateConfigurationArgs].
 */
@PulumiTagMarker
public class UpdateConfigurationArgsBuilder internal constructor() {
    private var azureVirtualMachines: Output<List<String>>? = null

    private var duration: Output<String>? = null

    private var linux: Output<LinuxPropertiesArgs>? = null

    private var nonAzureComputerNames: Output<List<String>>? = null

    private var operatingSystem: Output<OperatingSystemType>? = null

    private var targets: Output<TargetPropertiesArgs>? = null

    private var windows: Output<WindowsPropertiesArgs>? = null

    /**
     * @param value List of azure resource Ids for azure virtual machines targeted by the software update configuration.
     */
    @JvmName("vfthdoxaugfkgmdg")
    public suspend fun azureVirtualMachines(`value`: Output<List<String>>) {
        this.azureVirtualMachines = value
    }

    @JvmName("cdqhaieudredmwcf")
    public suspend fun azureVirtualMachines(vararg values: Output<String>) {
        this.azureVirtualMachines = Output.all(values.asList())
    }

    /**
     * @param values List of azure resource Ids for azure virtual machines targeted by the software update configuration.
     */
    @JvmName("qgbkmupmmelglxvv")
    public suspend fun azureVirtualMachines(values: List<Output<String>>) {
        this.azureVirtualMachines = Output.all(values)
    }

    /**
     * @param value Maximum time allowed for the software update configuration run. Duration needs to be specified using the format PT[n]H[n]M[n]S as per ISO8601
     */
    @JvmName("ycfqtibugutsotwh")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value Linux specific update configuration.
     */
    @JvmName("seimkeufulqoedbq")
    public suspend fun linux(`value`: Output<LinuxPropertiesArgs>) {
        this.linux = value
    }

    /**
     * @param value List of names of non-azure machines targeted by the software update configuration.
     */
    @JvmName("ugcxgdknvyuhsiws")
    public suspend fun nonAzureComputerNames(`value`: Output<List<String>>) {
        this.nonAzureComputerNames = value
    }

    @JvmName("snhibxbjmdidmlik")
    public suspend fun nonAzureComputerNames(vararg values: Output<String>) {
        this.nonAzureComputerNames = Output.all(values.asList())
    }

    /**
     * @param values List of names of non-azure machines targeted by the software update configuration.
     */
    @JvmName("qwyskoxuerhhlhof")
    public suspend fun nonAzureComputerNames(values: List<Output<String>>) {
        this.nonAzureComputerNames = Output.all(values)
    }

    /**
     * @param value operating system of target machines
     */
    @JvmName("jutjisifwglkdudl")
    public suspend fun operatingSystem(`value`: Output<OperatingSystemType>) {
        this.operatingSystem = value
    }

    /**
     * @param value Group targets for the software update configuration.
     */
    @JvmName("hwlcpjckipmjuxci")
    public suspend fun targets(`value`: Output<TargetPropertiesArgs>) {
        this.targets = value
    }

    /**
     * @param value Windows specific update configuration.
     */
    @JvmName("jshnrqahsqbhiqkb")
    public suspend fun windows(`value`: Output<WindowsPropertiesArgs>) {
        this.windows = value
    }

    /**
     * @param value List of azure resource Ids for azure virtual machines targeted by the software update configuration.
     */
    @JvmName("snprbfvewftdiomh")
    public suspend fun azureVirtualMachines(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureVirtualMachines = mapped
    }

    /**
     * @param values List of azure resource Ids for azure virtual machines targeted by the software update configuration.
     */
    @JvmName("rqmxckpeevjcbean")
    public suspend fun azureVirtualMachines(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureVirtualMachines = mapped
    }

    /**
     * @param value Maximum time allowed for the software update configuration run. Duration needs to be specified using the format PT[n]H[n]M[n]S as per ISO8601
     */
    @JvmName("klrjqoyanoowyrmk")
    public suspend fun duration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value Linux specific update configuration.
     */
    @JvmName("sduauropcwwllixx")
    public suspend fun linux(`value`: LinuxPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linux = mapped
    }

    /**
     * @param argument Linux specific update configuration.
     */
    @JvmName("jgxlbyswulanwtea")
    public suspend fun linux(argument: suspend LinuxPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = LinuxPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linux = mapped
    }

    /**
     * @param value List of names of non-azure machines targeted by the software update configuration.
     */
    @JvmName("qxvybdkewajsnryv")
    public suspend fun nonAzureComputerNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nonAzureComputerNames = mapped
    }

    /**
     * @param values List of names of non-azure machines targeted by the software update configuration.
     */
    @JvmName("hrjaokmdcwfdtyky")
    public suspend fun nonAzureComputerNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nonAzureComputerNames = mapped
    }

    /**
     * @param value operating system of target machines
     */
    @JvmName("lyxowmgrmstnkixs")
    public suspend fun operatingSystem(`value`: OperatingSystemType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatingSystem = mapped
    }

    /**
     * @param value Group targets for the software update configuration.
     */
    @JvmName("blmndjmyguxalnrm")
    public suspend fun targets(`value`: TargetPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param argument Group targets for the software update configuration.
     */
    @JvmName("befpxgwlwmkujciu")
    public suspend fun targets(argument: suspend TargetPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = TargetPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param value Windows specific update configuration.
     */
    @JvmName("gfahjdjdsdcutbyk")
    public suspend fun windows(`value`: WindowsPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windows = mapped
    }

    /**
     * @param argument Windows specific update configuration.
     */
    @JvmName("vbesppbafgxxhngv")
    public suspend fun windows(argument: suspend WindowsPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = WindowsPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.windows = mapped
    }

    internal fun build(): UpdateConfigurationArgs = UpdateConfigurationArgs(
        azureVirtualMachines = azureVirtualMachines,
        duration = duration,
        linux = linux,
        nonAzureComputerNames = nonAzureComputerNames,
        operatingSystem = operatingSystem ?: throw PulumiNullFieldException("operatingSystem"),
        targets = targets,
        windows = windows,
    )
}
