@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of the create Advanced Schedule.
 * @property monthDays Days of the month that the job should execute on. Must be between 1 and 31.
 * @property monthlyOccurrences Occurrences of days within a month.
 * @property weekDays Days of the week that the job should execute on.
 */
public data class AdvancedScheduleResponse(
    public val monthDays: List<Int>? = null,
    public val monthlyOccurrences: List<AdvancedScheduleMonthlyOccurrenceResponse>? = null,
    public val weekDays: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.AdvancedScheduleResponse): AdvancedScheduleResponse = AdvancedScheduleResponse(
            monthDays = javaType.monthDays().map({ args0 -> args0 }),
            monthlyOccurrences = javaType.monthlyOccurrences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.AdvancedScheduleMonthlyOccurrenceResponse.Companion.toKotlin(args0)
                })
            }),
            weekDays = javaType.weekDays().map({ args0 -> args0 }),
        )
    }
}
