@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure query for the update configuration.
 * @property locations List of locations to scope the query to.
 * @property scope List of Subscription or Resource Group ARM Ids.
 * @property tagSettings Tag settings for the VM.
 */
public data class AzureQueryPropertiesResponse(
    public val locations: List<String>? = null,
    public val scope: List<String>? = null,
    public val tagSettings: TagSettingsPropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.AzureQueryPropertiesResponse): AzureQueryPropertiesResponse = AzureQueryPropertiesResponse(
            locations = javaType.locations().map({ args0 -> args0 }),
            scope = javaType.scope().map({ args0 -> args0 }),
            tagSettings = javaType.tagSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.TagSettingsPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
