@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition of the runbook property type.
 * @property algorithm Gets or sets the content hash algorithm used to hash the content.
 * @property value Gets or sets expected hash value of the content.
 */
public data class ContentHashResponse(
    public val algorithm: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.ContentHashResponse): ContentHashResponse = ContentHashResponse(
            algorithm = javaType.algorithm(),
            `value` = javaType.`value`(),
        )
    }
}
