@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Definition of the connection fields.
 * @property isEncrypted Gets or sets the isEncrypted flag of the connection field definition.
 * @property isOptional Gets or sets the isOptional flag of the connection field definition.
 * @property type Gets or sets the type of the connection field definition.
 */
public data class FieldDefinitionResponse(
    public val isEncrypted: Boolean? = null,
    public val isOptional: Boolean? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.FieldDefinitionResponse): FieldDefinitionResponse = FieldDefinitionResponse(
            isEncrypted = javaType.isEncrypted().map({ args0 -> args0 }).orElse(null),
            isOptional = javaType.isOptional().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
