@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Definition of the automation account type.
 * @property automationHybridServiceUrl URL of automation hybrid service which is used for hybrid worker on-boarding.
 * @property creationTime Gets the creation time.
 * @property description Gets or sets the description.
 * @property disableLocalAuth Indicates whether requests using non-AAD authentication are blocked
 * @property encryption Encryption properties for the automation account
 * @property etag Gets or sets the etag of the resource.
 * @property id Fully qualified resource Id for the resource
 * @property identity Identity for the resource.
 * @property lastModifiedBy Gets or sets the last modified by.
 * @property lastModifiedTime Gets the last modified time.
 * @property location The Azure Region where the resource lives
 * @property name The name of the resource
 * @property privateEndpointConnections List of Automation operations supported by the Automation resource provider.
 * @property publicNetworkAccess Indicates whether traffic on the non-ARM endpoint (Webhook/Agent) is allowed from the public internet
 * @property sku Gets or sets the SKU of account.
 * @property state Gets status of account.
 * @property systemData Resource system metadata.
 * @property tags Resource tags.
 * @property type The type of the resource.
 */
public data class GetAutomationAccountResult(
    public val automationHybridServiceUrl: String? = null,
    public val creationTime: String,
    public val description: String? = null,
    public val disableLocalAuth: Boolean? = null,
    public val encryption: EncryptionPropertiesResponse? = null,
    public val etag: String? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val lastModifiedBy: String? = null,
    public val lastModifiedTime: String,
    public val location: String? = null,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>? = null,
    public val publicNetworkAccess: Boolean? = null,
    public val sku: SkuResponse? = null,
    public val state: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetAutomationAccountResult): GetAutomationAccountResult = GetAutomationAccountResult(
            automationHybridServiceUrl = javaType.automationHybridServiceUrl().map({ args0 ->
                args0
            }).orElse(null),
            creationTime = javaType.creationTime(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.EncryptionPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastModifiedBy = javaType.lastModifiedBy().map({ args0 -> args0 }).orElse(null),
            lastModifiedTime = javaType.lastModifiedTime(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.automation.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
