@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Definition of the certificate.
 * @property creationTime Gets the creation time.
 * @property description Gets or sets the description.
 * @property expiryTime Gets the expiry time of the certificate.
 * @property id Fully qualified resource Id for the resource
 * @property isExportable Gets the is exportable flag of the certificate.
 * @property lastModifiedTime Gets the last modified time.
 * @property name The name of the resource
 * @property thumbprint Gets the thumbprint of the certificate.
 * @property type The type of the resource.
 */
public data class GetCertificateResult(
    public val creationTime: String,
    public val description: String? = null,
    public val expiryTime: String,
    public val id: String,
    public val isExportable: Boolean,
    public val lastModifiedTime: String,
    public val name: String,
    public val thumbprint: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetCertificateResult): GetCertificateResult = GetCertificateResult(
            creationTime = javaType.creationTime(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            expiryTime = javaType.expiryTime(),
            id = javaType.id(),
            isExportable = javaType.isExportable(),
            lastModifiedTime = javaType.lastModifiedTime(),
            name = javaType.name(),
            thumbprint = javaType.thumbprint(),
            type = javaType.type(),
        )
    }
}
