@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition of hybrid runbook worker.
 * @property id Fully qualified resource Id for the resource
 * @property ip Gets or sets the assigned machine IP address.
 * @property lastSeenDateTime Last Heartbeat from the Worker
 * @property name The name of the resource
 * @property registeredDateTime Gets or sets the registration time of the worker machine.
 * @property systemData Resource system metadata.
 * @property type The type of the resource.
 * @property vmResourceId Azure Resource Manager Id for a virtual machine.
 * @property workerName Name of the HybridWorker.
 * @property workerType Type of the HybridWorker.
 */
public data class GetHybridRunbookWorkerResult(
    public val id: String,
    public val ip: String? = null,
    public val lastSeenDateTime: String? = null,
    public val name: String,
    public val registeredDateTime: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val vmResourceId: String? = null,
    public val workerName: String? = null,
    public val workerType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetHybridRunbookWorkerResult): GetHybridRunbookWorkerResult = GetHybridRunbookWorkerResult(
            id = javaType.id(),
            ip = javaType.ip().map({ args0 -> args0 }).orElse(null),
            lastSeenDateTime = javaType.lastSeenDateTime().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            registeredDateTime = javaType.registeredDateTime().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.automation.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            vmResourceId = javaType.vmResourceId().map({ args0 -> args0 }).orElse(null),
            workerName = javaType.workerName().map({ args0 -> args0 }).orElse(null),
            workerType = javaType.workerType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
