@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Definition of the job schedule.
 * @property id Gets the id of the resource.
 * @property jobScheduleId Gets or sets the id of job schedule.
 * @property name Gets the name of the variable.
 * @property parameters Gets or sets the parameters of the job schedule.
 * @property runOn Gets or sets the hybrid worker group that the scheduled job should run on.
 * @property runbook Gets or sets the runbook.
 * @property schedule Gets or sets the schedule.
 * @property type Resource type
 */
public data class GetJobScheduleResult(
    public val id: String,
    public val jobScheduleId: String? = null,
    public val name: String,
    public val parameters: Map<String, String>? = null,
    public val runOn: String? = null,
    public val runbook: RunbookAssociationPropertyResponse? = null,
    public val schedule: ScheduleAssociationPropertyResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetJobScheduleResult): GetJobScheduleResult = GetJobScheduleResult(
            id = javaType.id(),
            jobScheduleId = javaType.jobScheduleId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            runOn = javaType.runOn().map({ args0 -> args0 }).orElse(null),
            runbook = javaType.runbook().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.RunbookAssociationPropertyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            schedule = javaType.schedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.ScheduleAssociationPropertyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
