@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Definition of the Package type.
 * @property allOf Metadata pertaining to creation and last modification of the resource.
 * @property contentLink Gets or sets the contentLink of the Package.
 * @property default Gets or sets the isGlobal flag of the package.
 * @property error Gets or sets the error info of the Package.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Gets or sets the provisioning state of the Package.
 * @property sizeInBytes Gets or sets the size in bytes of the Package.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version Gets or sets the version of the Package.
 */
public data class GetPackageResult(
    public val allOf: SystemDataResponse,
    public val contentLink: ContentLinkResponse? = null,
    public val default: Boolean? = null,
    public val error: PackageErrorInfoResponse? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val sizeInBytes: Double? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetPackageResult): GetPackageResult = GetPackageResult(
            allOf = javaType.allOf().let({ args0 ->
                com.pulumi.azurenative.automation.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            contentLink = javaType.contentLink().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.ContentLinkResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            default = javaType.default_().map({ args0 -> args0 }).orElse(null),
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.PackageErrorInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sizeInBytes = javaType.sizeInBytes().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.automation.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
