@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A private endpoint connection
 * @property groupIds Gets the groupIds.
 * @property id Fully qualified resource Id for the resource
 * @property name The name of the resource
 * @property privateEndpoint Private endpoint which the connection belongs to.
 * @property privateLinkServiceConnectionState Connection State of the Private Endpoint Connection.
 * @property type The type of the resource.
 */
public data class GetPrivateEndpointConnectionResult(
    public val groupIds: List<String>? = null,
    public val id: String,
    public val name: String,
    public val privateEndpoint: PrivateEndpointPropertyResponse? = null,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStatePropertyResponse? =
        null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetPrivateEndpointConnectionResult): GetPrivateEndpointConnectionResult = GetPrivateEndpointConnectionResult(
            groupIds = javaType.groupIds().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.PrivateEndpointPropertyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.PrivateLinkServiceConnectionStatePropertyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
