@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Definition of the runbook type.
 * @property creationTime Gets or sets the creation time.
 * @property description Gets or sets the description.
 * @property draft Gets or sets the draft runbook properties.
 * @property etag Gets or sets the etag of the resource.
 * @property id Fully qualified resource Id for the resource
 * @property jobCount Gets or sets the job count of the runbook.
 * @property lastModifiedBy Gets or sets the last modified by.
 * @property lastModifiedTime Gets or sets the last modified time.
 * @property location The Azure Region where the resource lives
 * @property logActivityTrace Gets or sets the option to log activity trace of the runbook.
 * @property logProgress Gets or sets progress log option.
 * @property logVerbose Gets or sets verbose log option.
 * @property name The name of the resource
 * @property outputTypes Gets or sets the runbook output types.
 * @property parameters Gets or sets the runbook parameters.
 * @property provisioningState Gets or sets the provisioning state of the runbook.
 * @property publishContentLink Gets or sets the published runbook content link.
 * @property runbookType Gets or sets the type of the runbook.
 * @property state Gets or sets the state of the runbook.
 * @property tags Resource tags.
 * @property type The type of the resource.
 */
public data class GetRunbookResult(
    public val creationTime: String? = null,
    public val description: String? = null,
    public val draft: RunbookDraftResponse? = null,
    public val etag: String? = null,
    public val id: String,
    public val jobCount: Int? = null,
    public val lastModifiedBy: String? = null,
    public val lastModifiedTime: String? = null,
    public val location: String? = null,
    public val logActivityTrace: Int? = null,
    public val logProgress: Boolean? = null,
    public val logVerbose: Boolean? = null,
    public val name: String,
    public val outputTypes: List<String>? = null,
    public val parameters: Map<String, RunbookParameterResponse>? = null,
    public val provisioningState: String? = null,
    public val publishContentLink: ContentLinkResponse? = null,
    public val runbookType: String? = null,
    public val state: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetRunbookResult): GetRunbookResult = GetRunbookResult(
            creationTime = javaType.creationTime().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            draft = javaType.draft().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.RunbookDraftResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            jobCount = javaType.jobCount().map({ args0 -> args0 }).orElse(null),
            lastModifiedBy = javaType.lastModifiedBy().map({ args0 -> args0 }).orElse(null),
            lastModifiedTime = javaType.lastModifiedTime().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            logActivityTrace = javaType.logActivityTrace().map({ args0 -> args0 }).orElse(null),
            logProgress = javaType.logProgress().map({ args0 -> args0 }).orElse(null),
            logVerbose = javaType.logVerbose().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            outputTypes = javaType.outputTypes().map({ args0 -> args0 }),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.automation.kotlin.outputs.RunbookParameterResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            publishContentLink = javaType.publishContentLink().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.ContentLinkResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            runbookType = javaType.runbookType().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
