@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Definition of the schedule.
 * @property advancedSchedule Gets or sets the advanced schedule.
 * @property creationTime Gets or sets the creation time.
 * @property description Gets or sets the description.
 * @property expiryTime Gets or sets the end time of the schedule.
 * @property expiryTimeOffsetMinutes Gets or sets the expiry time's offset in minutes.
 * @property frequency Gets or sets the frequency of the schedule.
 * @property id Fully qualified resource Id for the resource
 * @property interval Gets or sets the interval of the schedule.
 * @property isEnabled Gets or sets a value indicating whether this schedule is enabled.
 * @property lastModifiedTime Gets or sets the last modified time.
 * @property name The name of the resource
 * @property nextRun Gets or sets the next run time of the schedule.
 * @property nextRunOffsetMinutes Gets or sets the next run time's offset in minutes.
 * @property startTime Gets or sets the start time of the schedule.
 * @property startTimeOffsetMinutes Gets the start time's offset in minutes.
 * @property timeZone Gets or sets the time zone of the schedule.
 * @property type The type of the resource.
 */
public data class GetScheduleResult(
    public val advancedSchedule: AdvancedScheduleResponse? = null,
    public val creationTime: String? = null,
    public val description: String? = null,
    public val expiryTime: String? = null,
    public val expiryTimeOffsetMinutes: Double? = null,
    public val frequency: String? = null,
    public val id: String,
    public val interval: Any? = null,
    public val isEnabled: Boolean? = null,
    public val lastModifiedTime: String? = null,
    public val name: String,
    public val nextRun: String? = null,
    public val nextRunOffsetMinutes: Double? = null,
    public val startTime: String? = null,
    public val startTimeOffsetMinutes: Double,
    public val timeZone: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetScheduleResult): GetScheduleResult = GetScheduleResult(
            advancedSchedule = javaType.advancedSchedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.AdvancedScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            creationTime = javaType.creationTime().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            expiryTime = javaType.expiryTime().map({ args0 -> args0 }).orElse(null),
            expiryTimeOffsetMinutes = javaType.expiryTimeOffsetMinutes().map({ args0 -> args0 }).orElse(null),
            frequency = javaType.frequency().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
            lastModifiedTime = javaType.lastModifiedTime().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            nextRun = javaType.nextRun().map({ args0 -> args0 }).orElse(null),
            nextRunOffsetMinutes = javaType.nextRunOffsetMinutes().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            startTimeOffsetMinutes = javaType.startTimeOffsetMinutes(),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
