@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Software update configuration properties.
 * @property createdBy CreatedBy property, which only appears in the response.
 * @property creationTime Creation time of the resource, which only appears in the response.
 * @property error Details of provisioning error
 * @property id Resource Id.
 * @property lastModifiedBy LastModifiedBy property, which only appears in the response.
 * @property lastModifiedTime Last time resource was modified, which only appears in the response.
 * @property name Resource name.
 * @property provisioningState Provisioning state for the software update configuration, which only appears in the response.
 * @property scheduleInfo Schedule information for the Software update configuration
 * @property tasks Tasks information for the Software update configuration.
 * @property type Resource type
 * @property updateConfiguration update specific properties for the Software update configuration
 */
public data class GetSoftwareUpdateConfigurationByNameResult(
    public val createdBy: String,
    public val creationTime: String,
    public val error: ErrorResponseResponse? = null,
    public val id: String,
    public val lastModifiedBy: String,
    public val lastModifiedTime: String,
    public val name: String,
    public val provisioningState: String,
    public val scheduleInfo: SUCSchedulePropertiesResponse,
    public val tasks: SoftwareUpdateConfigurationTasksResponse? = null,
    public val type: String,
    public val updateConfiguration: UpdateConfigurationResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetSoftwareUpdateConfigurationByNameResult): GetSoftwareUpdateConfigurationByNameResult = GetSoftwareUpdateConfigurationByNameResult(
            createdBy = javaType.createdBy(),
            creationTime = javaType.creationTime(),
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.ErrorResponseResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            lastModifiedBy = javaType.lastModifiedBy(),
            lastModifiedTime = javaType.lastModifiedTime(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            scheduleInfo = javaType.scheduleInfo().let({ args0 ->
                com.pulumi.azurenative.automation.kotlin.outputs.SUCSchedulePropertiesResponse.Companion.toKotlin(args0)
            }),
            tasks = javaType.tasks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.SoftwareUpdateConfigurationTasksResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            updateConfiguration = javaType.updateConfiguration().let({ args0 ->
                com.pulumi.azurenative.automation.kotlin.outputs.UpdateConfigurationResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
