@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Definition of the source control.
 * @property autoSync The auto sync of the source control. Default is false.
 * @property branch The repo branch of the source control. Include branch as empty string for VsoTfvc.
 * @property creationTime The creation time.
 * @property description The description.
 * @property folderPath The folder path of the source control.
 * @property id Fully qualified resource Id for the resource
 * @property lastModifiedTime The last modified time.
 * @property name The name of the resource
 * @property publishRunbook The auto publish of the source control. Default is true.
 * @property repoUrl The repo url of the source control.
 * @property sourceType The source type. Must be one of VsoGit, VsoTfvc, GitHub.
 * @property type The type of the resource.
 */
public data class GetSourceControlResult(
    public val autoSync: Boolean? = null,
    public val branch: String? = null,
    public val creationTime: String? = null,
    public val description: String? = null,
    public val folderPath: String? = null,
    public val id: String,
    public val lastModifiedTime: String? = null,
    public val name: String,
    public val publishRunbook: Boolean? = null,
    public val repoUrl: String? = null,
    public val sourceType: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetSourceControlResult): GetSourceControlResult = GetSourceControlResult(
            autoSync = javaType.autoSync().map({ args0 -> args0 }).orElse(null),
            branch = javaType.branch().map({ args0 -> args0 }).orElse(null),
            creationTime = javaType.creationTime().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            folderPath = javaType.folderPath().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastModifiedTime = javaType.lastModifiedTime().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            publishRunbook = javaType.publishRunbook().map({ args0 -> args0 }).orElse(null),
            repoUrl = javaType.repoUrl().map({ args0 -> args0 }).orElse(null),
            sourceType = javaType.sourceType().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
