@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Definition of the variable.
 * @property creationTime Gets or sets the creation time.
 * @property description Gets or sets the description.
 * @property id Fully qualified resource Id for the resource
 * @property isEncrypted Gets or sets the encrypted flag of the variable.
 * @property lastModifiedTime Gets or sets the last modified time.
 * @property name The name of the resource
 * @property type The type of the resource.
 * @property value Gets or sets the value of the variable.
 */
public data class GetVariableResult(
    public val creationTime: String? = null,
    public val description: String? = null,
    public val id: String,
    public val isEncrypted: Boolean? = null,
    public val lastModifiedTime: String? = null,
    public val name: String,
    public val type: String,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetVariableResult): GetVariableResult = GetVariableResult(
            creationTime = javaType.creationTime().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isEncrypted = javaType.isEncrypted().map({ args0 -> args0 }).orElse(null),
            lastModifiedTime = javaType.lastModifiedTime().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
