@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Definition of the webhook type.
 * @property creationTime Gets or sets the creation time.
 * @property description Gets or sets the description.
 * @property expiryTime Gets or sets the expiry time.
 * @property id Fully qualified resource Id for the resource
 * @property isEnabled Gets or sets the value of the enabled flag of the webhook.
 * @property lastInvokedTime Gets or sets the last invoked time.
 * @property lastModifiedBy Details of the user who last modified the Webhook
 * @property lastModifiedTime Gets or sets the last modified time.
 * @property name The name of the resource
 * @property parameters Gets or sets the parameters of the job that is created when the webhook calls the runbook it is associated with.
 * @property runOn Gets or sets the name of the hybrid worker group the webhook job will run on.
 * @property runbook Gets or sets the runbook the webhook is associated with.
 * @property type The type of the resource.
 * @property uri Gets or sets the webhook uri.
 */
public data class GetWebhookResult(
    public val creationTime: String? = null,
    public val description: String? = null,
    public val expiryTime: String? = null,
    public val id: String,
    public val isEnabled: Boolean? = null,
    public val lastInvokedTime: String? = null,
    public val lastModifiedBy: String? = null,
    public val lastModifiedTime: String? = null,
    public val name: String,
    public val parameters: Map<String, String>? = null,
    public val runOn: String? = null,
    public val runbook: RunbookAssociationPropertyResponse? = null,
    public val type: String,
    public val uri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetWebhookResult): GetWebhookResult = GetWebhookResult(
            creationTime = javaType.creationTime().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            expiryTime = javaType.expiryTime().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
            lastInvokedTime = javaType.lastInvokedTime().map({ args0 -> args0 }).orElse(null),
            lastModifiedBy = javaType.lastModifiedBy().map({ args0 -> args0 }).orElse(null),
            lastModifiedTime = javaType.lastModifiedTime().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            runOn = javaType.runOn().map({ args0 -> args0 }).orElse(null),
            runbook = javaType.runbook().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.RunbookAssociationPropertyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
