@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Settings concerning key vault encryption for a configuration store.
 * @property keyName The name of key used to encrypt data.
 * @property keyVersion The key version of the key used to encrypt data.
 * @property keyvaultUri The URI of the key vault key used to encrypt data.
 */
public data class KeyVaultPropertiesResponse(
    public val keyName: String? = null,
    public val keyVersion: String? = null,
    public val keyvaultUri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.KeyVaultPropertiesResponse): KeyVaultPropertiesResponse = KeyVaultPropertiesResponse(
            keyName = javaType.keyName().map({ args0 -> args0 }).orElse(null),
            keyVersion = javaType.keyVersion().map({ args0 -> args0 }).orElse(null),
            keyvaultUri = javaType.keyvaultUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
