@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Linux specific update configuration.
 * @property excludedPackageNameMasks packages excluded from the software update configuration.
 * @property includedPackageClassifications Update classifications included in the software update configuration.
 * @property includedPackageNameMasks packages included from the software update configuration.
 * @property rebootSetting Reboot setting for the software update configuration.
 */
public data class LinuxPropertiesResponse(
    public val excludedPackageNameMasks: List<String>? = null,
    public val includedPackageClassifications: String? = null,
    public val includedPackageNameMasks: List<String>? = null,
    public val rebootSetting: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.LinuxPropertiesResponse): LinuxPropertiesResponse = LinuxPropertiesResponse(
            excludedPackageNameMasks = javaType.excludedPackageNameMasks().map({ args0 -> args0 }),
            includedPackageClassifications = javaType.includedPackageClassifications().map({ args0 ->
                args0
            }).orElse(null),
            includedPackageNameMasks = javaType.includedPackageNameMasks().map({ args0 -> args0 }),
            rebootSetting = javaType.rebootSetting().map({ args0 -> args0 }).orElse(null),
        )
    }
}
