@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition of the package error info type.
 * @property code Package import error code.
 * @property message Package import error message.
 */
public data class PackageErrorInfoResponse(
    public val code: String? = null,
    public val message: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.PackageErrorInfoResponse): PackageErrorInfoResponse = PackageErrorInfoResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
        )
    }
}
