@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property creationTime Gets or sets the creation time of the runbook draft.
 * @property draftContentLink Gets or sets the draft runbook content link.
 * @property inEdit Gets or sets whether runbook is in edit mode.
 * @property lastModifiedTime Gets or sets the last modified time of the runbook draft.
 * @property outputTypes Gets or sets the runbook output types.
 * @property parameters Gets or sets the runbook draft parameters.
 */
public data class RunbookDraftResponse(
    public val creationTime: String? = null,
    public val draftContentLink: ContentLinkResponse? = null,
    public val inEdit: Boolean? = null,
    public val lastModifiedTime: String? = null,
    public val outputTypes: List<String>? = null,
    public val parameters: Map<String, RunbookParameterResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.RunbookDraftResponse): RunbookDraftResponse = RunbookDraftResponse(
            creationTime = javaType.creationTime().map({ args0 -> args0 }).orElse(null),
            draftContentLink = javaType.draftContentLink().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.ContentLinkResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            inEdit = javaType.inEdit().map({ args0 -> args0 }).orElse(null),
            lastModifiedTime = javaType.lastModifiedTime().map({ args0 -> args0 }).orElse(null),
            outputTypes = javaType.outputTypes().map({ args0 -> args0 }),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.automation.kotlin.outputs.RunbookParameterResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
