@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Suppress

/**
 * Task properties of the software update configuration.
 * @property postTask Post task properties.
 * @property preTask Pre task properties.
 */
public data class SoftwareUpdateConfigurationTasksResponse(
    public val postTask: TaskPropertiesResponse? = null,
    public val preTask: TaskPropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.SoftwareUpdateConfigurationTasksResponse): SoftwareUpdateConfigurationTasksResponse = SoftwareUpdateConfigurationTasksResponse(
            postTask = javaType.postTask().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.TaskPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            preTask = javaType.preTask().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.TaskPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
