@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Tag filter information for the VM.
 * @property filterOperator Filter VMs by Any or All specified tags.
 * @property tags Dictionary of tags with its list of values.
 */
public data class TagSettingsPropertiesResponse(
    public val filterOperator: String? = null,
    public val tags: Map<String, List<String>>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.TagSettingsPropertiesResponse): TagSettingsPropertiesResponse = TagSettingsPropertiesResponse(
            filterOperator = javaType.filterOperator().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value.map({ args0 -> args0 })) }).toMap(),
        )
    }
}
