@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Task properties of the software update configuration.
 * @property parameters Gets or sets the parameters of the task.
 * @property source Gets or sets the name of the runbook.
 */
public data class TaskPropertiesResponse(
    public val parameters: Map<String, String>? = null,
    public val source: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.TaskPropertiesResponse): TaskPropertiesResponse = TaskPropertiesResponse(
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
        )
    }
}
