@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Update specific properties of the software update configuration.
 * @property azureVirtualMachines List of azure resource Ids for azure virtual machines targeted by the software update configuration.
 * @property duration Maximum time allowed for the software update configuration run. Duration needs to be specified using the format PT[n]H[n]M[n]S as per ISO8601
 * @property linux Linux specific update configuration.
 * @property nonAzureComputerNames List of names of non-azure machines targeted by the software update configuration.
 * @property operatingSystem operating system of target machines
 * @property targets Group targets for the software update configuration.
 * @property windows Windows specific update configuration.
 */
public data class UpdateConfigurationResponse(
    public val azureVirtualMachines: List<String>? = null,
    public val duration: String? = null,
    public val linux: LinuxPropertiesResponse? = null,
    public val nonAzureComputerNames: List<String>? = null,
    public val operatingSystem: String,
    public val targets: TargetPropertiesResponse? = null,
    public val windows: WindowsPropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.UpdateConfigurationResponse): UpdateConfigurationResponse = UpdateConfigurationResponse(
            azureVirtualMachines = javaType.azureVirtualMachines().map({ args0 -> args0 }),
            duration = javaType.duration().map({ args0 -> args0 }).orElse(null),
            linux = javaType.linux().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.LinuxPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            nonAzureComputerNames = javaType.nonAzureComputerNames().map({ args0 -> args0 }),
            operatingSystem = javaType.operatingSystem(),
            targets = javaType.targets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.TargetPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            windows = javaType.windows().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.WindowsPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
