@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Encryption properties of a Data Pool
 * @property keyName The name of Key Vault key
 * @property keyVaultUri The URI of a soft delete-enabled Key Vault that is in the same location as the Data Pool location
 * @property keyVersion The version of Key Vault key
 * @property userAssignedIdentity The resource ID of a user-assigned Managed Identity used to access the encryption key in the Key Vault. Requires access to the key operations get, wrap, unwrap, and recover
 */
public data class DataPoolEncryptionResponse(
    public val keyName: String,
    public val keyVaultUri: String,
    public val keyVersion: String? = null,
    public val userAssignedIdentity: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.autonomousdevelopmentplatform.outputs.DataPoolEncryptionResponse): DataPoolEncryptionResponse = DataPoolEncryptionResponse(
            keyName = javaType.keyName(),
            keyVaultUri = javaType.keyVaultUri(),
            keyVersion = javaType.keyVersion().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentity = javaType.userAssignedIdentity(),
        )
    }
}
