@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Location of a Data Pool
 * @property encryption Encryption properties of a Data Pool location
 * @property name The location name
 * @property storageAccountCount The amount of storage accounts provisioned per Data Pool. Default: 5
 * @property storageSku The Storage SKU. Default: Standard_ZRS.
 */
public data class DataPoolLocationResponse(
    public val encryption: DataPoolEncryptionResponse? = null,
    public val name: String,
    public val storageAccountCount: Int? = null,
    public val storageSku: StorageSkuResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.autonomousdevelopmentplatform.outputs.DataPoolLocationResponse): DataPoolLocationResponse = DataPoolLocationResponse(
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.outputs.DataPoolEncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            storageAccountCount = javaType.storageAccountCount().map({ args0 -> args0 }).orElse(null),
            storageSku = javaType.storageSku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.outputs.StorageSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
