@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.AddonArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An addon resource
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-07-17-preview.
 * Other available API versions: 2021-01-01-preview, 2023-03-01, 2023-09-01.
 * ## Example Usage
 * ### Addons_CreateOrUpdate_Arc
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var addon = new AzureNative.AVS.Addon("addon", new()
 *     {
 *         AddonName = "arc",
 *         PrivateCloudName = "cloud1",
 *         Properties = new AzureNative.AVS.Inputs.AddonArcPropertiesArgs
 *         {
 *             AddonType = "Arc",
 *             VCenter = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg_test/providers/Microsoft.ConnectedVMwarevSphere/VCenters/test-vcenter",
 *         },
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewAddon(ctx, "addon", &avs.AddonArgs{
 * 			AddonName:        pulumi.String("arc"),
 * 			PrivateCloudName: pulumi.String("cloud1"),
 * 			Properties: avs.AddonArcProperties{
 * 				AddonType: "Arc",
 * 				VCenter:   "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg_test/providers/Microsoft.ConnectedVMwarevSphere/VCenters/test-vcenter",
 * 			},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.Addon;
 * import com.pulumi.azurenative.avs.AddonArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var addon = new Addon("addon", AddonArgs.builder()
 *             .addonName("arc")
 *             .privateCloudName("cloud1")
 *             .properties(AddonArcPropertiesArgs.builder()
 *                 .addonType("Arc")
 *                 .vCenter("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg_test/providers/Microsoft.ConnectedVMwarevSphere/VCenters/test-vcenter")
 *                 .build())
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ### Addons_CreateOrUpdate_HCX
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var addon = new AzureNative.AVS.Addon("addon", new()
 *     {
 *         AddonName = "hcx",
 *         PrivateCloudName = "cloud1",
 *         Properties = new AzureNative.AVS.Inputs.AddonHcxPropertiesArgs
 *         {
 *             AddonType = "HCX",
 *             Offer = "VMware MaaS Cloud Provider (Enterprise)",
 *         },
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewAddon(ctx, "addon", &avs.AddonArgs{
 * 			AddonName:        pulumi.String("hcx"),
 * 			PrivateCloudName: pulumi.String("cloud1"),
 * 			Properties: avs.AddonHcxProperties{
 * 				AddonType: "HCX",
 * 				Offer:     "VMware MaaS Cloud Provider (Enterprise)",
 * 			},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.Addon;
 * import com.pulumi.azurenative.avs.AddonArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var addon = new Addon("addon", AddonArgs.builder()
 *             .addonName("hcx")
 *             .privateCloudName("cloud1")
 *             .properties(AddonArcPropertiesArgs.builder()
 *                 .addonType("HCX")
 *                 .offer("VMware MaaS Cloud Provider (Enterprise)")
 *                 .build())
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ### Addons_CreateOrUpdate_SRM
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var addon = new AzureNative.AVS.Addon("addon", new()
 *     {
 *         AddonName = "srm",
 *         PrivateCloudName = "cloud1",
 *         Properties = new AzureNative.AVS.Inputs.AddonSrmPropertiesArgs
 *         {
 *             AddonType = "SRM",
 *             LicenseKey = "41915178-A8FF-4A4D-B683-6D735AF5E3F5",
 *         },
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewAddon(ctx, "addon", &avs.AddonArgs{
 * 			AddonName:        pulumi.String("srm"),
 * 			PrivateCloudName: pulumi.String("cloud1"),
 * 			Properties: avs.AddonSrmProperties{
 * 				AddonType:  "SRM",
 * 				LicenseKey: "41915178-A8FF-4A4D-B683-6D735AF5E3F5",
 * 			},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.Addon;
 * import com.pulumi.azurenative.avs.AddonArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var addon = new Addon("addon", AddonArgs.builder()
 *             .addonName("srm")
 *             .privateCloudName("cloud1")
 *             .properties(AddonArcPropertiesArgs.builder()
 *                 .addonType("SRM")
 *                 .licenseKey("41915178-A8FF-4A4D-B683-6D735AF5E3F5")
 *                 .build())
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ### Addons_CreateOrUpdate_VR
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var addon = new AzureNative.AVS.Addon("addon", new()
 *     {
 *         AddonName = "vr",
 *         PrivateCloudName = "cloud1",
 *         Properties = new AzureNative.AVS.Inputs.AddonVrPropertiesArgs
 *         {
 *             AddonType = "VR",
 *             VrsCount = 1,
 *         },
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewAddon(ctx, "addon", &avs.AddonArgs{
 * 			AddonName:        pulumi.String("vr"),
 * 			PrivateCloudName: pulumi.String("cloud1"),
 * 			Properties: avs.AddonVrProperties{
 * 				AddonType: "VR",
 * 				VrsCount:  1,
 * 			},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.Addon;
 * import com.pulumi.azurenative.avs.AddonArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var addon = new Addon("addon", AddonArgs.builder()
 *             .addonName("vr")
 *             .privateCloudName("cloud1")
 *             .properties(AddonArcPropertiesArgs.builder()
 *                 .addonType("VR")
 *                 .vrsCount(1)
 *                 .build())
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:Addon vr /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/addons/{addonName}
 * ```
 * @property addonName Name of the addon for the private cloud
 * @property privateCloudName The name of the private cloud.
 * @property properties The properties of an addon resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class AddonArgs(
    public val addonName: Output<String>? = null,
    public val privateCloudName: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.AddonArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.AddonArgs =
        com.pulumi.azurenative.avs.AddonArgs.builder()
            .addonName(addonName?.applyValue({ args0 -> args0 }))
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddonArgs].
 */
@PulumiTagMarker
public class AddonArgsBuilder internal constructor() {
    private var addonName: Output<String>? = null

    private var privateCloudName: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the addon for the private cloud
     */
    @JvmName("kpfboiretpdalsbp")
    public suspend fun addonName(`value`: Output<String>) {
        this.addonName = value
    }

    /**
     * @param value The name of the private cloud.
     */
    @JvmName("cqiuuoefimlboapj")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value The properties of an addon resource
     */
    @JvmName("bdmfskiohunolkwi")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vyleqtnjyvgaljkj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the addon for the private cloud
     */
    @JvmName("qjbpdpwlrrrgknbl")
    public suspend fun addonName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addonName = mapped
    }

    /**
     * @param value The name of the private cloud.
     */
    @JvmName("wnwujewykahjpddx")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value The properties of an addon resource
     */
    @JvmName("mijiatvyivcbknil")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ihtkiolkemovaeyv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): AddonArgs = AddonArgs(
        addonName = addonName,
        privateCloudName = privateCloudName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
