@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GlobalReachConnection].
 */
@PulumiTagMarker
public class GlobalReachConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GlobalReachConnectionArgs = GlobalReachConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GlobalReachConnectionArgsBuilder.() -> Unit) {
        val builder = GlobalReachConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GlobalReachConnection {
        val builtJavaResource =
            com.pulumi.azurenative.avs.GlobalReachConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GlobalReachConnection(builtJavaResource)
    }
}

/**
 * A global reach connection resource
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-07-17-preview.
 * Other available API versions: 2023-03-01, 2023-09-01.
 * ## Example Usage
 * ### GlobalReachConnections_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var globalReachConnection = new AzureNative.AVS.GlobalReachConnection("globalReachConnection", new()
 *     {
 *         AuthorizationKey = "01010101-0101-0101-0101-010101010101",
 *         GlobalReachConnectionName = "connection1",
 *         PeerExpressRouteCircuit = "/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.Network/expressRouteCircuits/mypeer",
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewGlobalReachConnection(ctx, "globalReachConnection", &avs.GlobalReachConnectionArgs{
 * 			AuthorizationKey:          pulumi.String("01010101-0101-0101-0101-010101010101"),
 * 			GlobalReachConnectionName: pulumi.String("connection1"),
 * 			PeerExpressRouteCircuit:   pulumi.String("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.Network/expressRouteCircuits/mypeer"),
 * 			PrivateCloudName:          pulumi.String("cloud1"),
 * 			ResourceGroupName:         pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.GlobalReachConnection;
 * import com.pulumi.azurenative.avs.GlobalReachConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var globalReachConnection = new GlobalReachConnection("globalReachConnection", GlobalReachConnectionArgs.builder()
 *             .authorizationKey("01010101-0101-0101-0101-010101010101")
 *             .globalReachConnectionName("connection1")
 *             .peerExpressRouteCircuit("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.Network/expressRouteCircuits/mypeer")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:GlobalReachConnection connection1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/globalReachConnections/{globalReachConnectionName}
 * ```
 */
public class GlobalReachConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.avs.GlobalReachConnection,
) : KotlinCustomResource(javaResource, GlobalReachConnectionMapper) {
    /**
     * The network used for global reach carved out from the original network block provided for the private cloud
     */
    public val addressPrefix: Output<String>
        get() = javaResource.addressPrefix().applyValue({ args0 -> args0 })

    /**
     * Authorization key from the peer express route used for the global reach connection
     */
    public val authorizationKey: Output<String>?
        get() = javaResource.authorizationKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The connection status of the global reach connection
     */
    public val circuitConnectionStatus: Output<String>
        get() = javaResource.circuitConnectionStatus().applyValue({ args0 -> args0 })

    /**
     * The ID of the Private Cloud's ExpressRoute Circuit that is participating in the global reach connection
     */
    public val expressRouteId: Output<String>?
        get() = javaResource.expressRouteId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Identifier of the ExpressRoute Circuit to peer with in the global reach connection
     */
    public val peerExpressRouteCircuit: Output<String>?
        get() = javaResource.peerExpressRouteCircuit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The state of the  ExpressRoute Circuit Authorization provisioning
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GlobalReachConnectionMapper : ResourceMapper<GlobalReachConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.avs.GlobalReachConnection::class == javaResource::class

    override fun map(javaResource: Resource): GlobalReachConnection =
        GlobalReachConnection(javaResource as com.pulumi.azurenative.avs.GlobalReachConnection)
}

/**
 * @see [GlobalReachConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GlobalReachConnection].
 */
public suspend fun globalReachConnection(
    name: String,
    block: suspend GlobalReachConnectionResourceBuilder.() -> Unit,
): GlobalReachConnection {
    val builder = GlobalReachConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GlobalReachConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun globalReachConnection(name: String): GlobalReachConnection {
    val builder = GlobalReachConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
