@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.kotlin.outputs.WorkloadNetworkDhcpRelayResponse
import com.pulumi.azurenative.avs.kotlin.outputs.WorkloadNetworkDhcpServerResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkloadNetworkDhcp].
 */
@PulumiTagMarker
public class WorkloadNetworkDhcpResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkloadNetworkDhcpArgs = WorkloadNetworkDhcpArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkloadNetworkDhcpArgsBuilder.() -> Unit) {
        val builder = WorkloadNetworkDhcpArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkloadNetworkDhcp {
        val builtJavaResource = com.pulumi.azurenative.avs.WorkloadNetworkDhcp(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WorkloadNetworkDhcp(builtJavaResource)
    }
}

/**
 * NSX DHCP
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-07-17-preview.
 * Other available API versions: 2021-01-01-preview, 2023-03-01, 2023-09-01.
 * ## Example Usage
 * ### WorkloadNetworks_CreateDhcp
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadNetworkDhcp = new AzureNative.AVS.WorkloadNetworkDhcp("workloadNetworkDhcp", new()
 *     {
 *         DhcpId = "dhcp1",
 *         PrivateCloudName = "cloud1",
 *         Properties = new AzureNative.AVS.Inputs.WorkloadNetworkDhcpServerArgs
 *         {
 *             DhcpType = "SERVER",
 *             DisplayName = "dhcpConfigurations1",
 *             LeaseTime = 86400,
 *             Revision = 1,
 *             ServerAddress = "40.1.5.1/24",
 *         },
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewWorkloadNetworkDhcp(ctx, "workloadNetworkDhcp", &avs.WorkloadNetworkDhcpArgs{
 * 			DhcpId:           pulumi.String("dhcp1"),
 * 			PrivateCloudName: pulumi.String("cloud1"),
 * 			Properties: avs.WorkloadNetworkDhcpServer{
 * 				DhcpType:      "SERVER",
 * 				DisplayName:   "dhcpConfigurations1",
 * 				LeaseTime:     86400,
 * 				Revision:      1,
 * 				ServerAddress: "40.1.5.1/24",
 * 			},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.WorkloadNetworkDhcp;
 * import com.pulumi.azurenative.avs.WorkloadNetworkDhcpArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadNetworkDhcp = new WorkloadNetworkDhcp("workloadNetworkDhcp", WorkloadNetworkDhcpArgs.builder()
 *             .dhcpId("dhcp1")
 *             .privateCloudName("cloud1")
 *             .properties(WorkloadNetworkDhcpRelayArgs.builder()
 *                 .dhcpType("SERVER")
 *                 .displayName("dhcpConfigurations1")
 *                 .leaseTime(86400)
 *                 .revision(1)
 *                 .serverAddress("40.1.5.1/24")
 *                 .build())
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:WorkloadNetworkDhcp dhcp1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dhcpConfigurations/{dhcpId}
 * ```
 */
public class WorkloadNetworkDhcp internal constructor(
    override val javaResource: com.pulumi.azurenative.avs.WorkloadNetworkDhcp,
) : KotlinCustomResource(javaResource, WorkloadNetworkDhcpMapper) {
    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * DHCP properties.
     */
    public val properties:
        Output<Either<WorkloadNetworkDhcpRelayResponse, WorkloadNetworkDhcpServerResponse>>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.avs.kotlin.outputs.WorkloadNetworkDhcpRelayResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.avs.kotlin.outputs.WorkloadNetworkDhcpServerResponse.Companion.toKotlin(args0)
                    })
                },
            )
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkloadNetworkDhcpMapper : ResourceMapper<WorkloadNetworkDhcp> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.avs.WorkloadNetworkDhcp::class == javaResource::class

    override fun map(javaResource: Resource): WorkloadNetworkDhcp = WorkloadNetworkDhcp(
        javaResource
            as com.pulumi.azurenative.avs.WorkloadNetworkDhcp,
    )
}

/**
 * @see [WorkloadNetworkDhcp].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkloadNetworkDhcp].
 */
public suspend fun workloadNetworkDhcp(
    name: String,
    block: suspend WorkloadNetworkDhcpResourceBuilder.() -> Unit,
): WorkloadNetworkDhcp {
    val builder = WorkloadNetworkDhcpResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkloadNetworkDhcp].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workloadNetworkDhcp(name: String): WorkloadNetworkDhcp {
    val builder = WorkloadNetworkDhcpResourceBuilder()
    builder.name(name)
    return builder.build()
}
