@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkloadNetworkPortMirroring].
 */
@PulumiTagMarker
public class WorkloadNetworkPortMirroringResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkloadNetworkPortMirroringArgs = WorkloadNetworkPortMirroringArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkloadNetworkPortMirroringArgsBuilder.() -> Unit) {
        val builder = WorkloadNetworkPortMirroringArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkloadNetworkPortMirroring {
        val builtJavaResource =
            com.pulumi.azurenative.avs.WorkloadNetworkPortMirroring(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkloadNetworkPortMirroring(builtJavaResource)
    }
}

/**
 * NSX Port Mirroring
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-07-17-preview.
 * Other available API versions: 2023-03-01, 2023-09-01.
 * ## Example Usage
 * ### WorkloadNetworks_CreatePortMirroring
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadNetworkPortMirroring = new AzureNative.AVS.WorkloadNetworkPortMirroring("workloadNetworkPortMirroring", new()
 *     {
 *         Destination = "vmGroup2",
 *         Direction = AzureNative.AVS.PortMirroringDirectionEnum.BIDIRECTIONAL,
 *         DisplayName = "portMirroring1",
 *         PortMirroringId = "portMirroring1",
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *         Revision = 1,
 *         Source = "vmGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewWorkloadNetworkPortMirroring(ctx, "workloadNetworkPortMirroring", &avs.WorkloadNetworkPortMirroringArgs{
 * 			Destination:       pulumi.String("vmGroup2"),
 * 			Direction:         pulumi.String(avs.PortMirroringDirectionEnumBIDIRECTIONAL),
 * 			DisplayName:       pulumi.String("portMirroring1"),
 * 			PortMirroringId:   pulumi.String("portMirroring1"),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Revision:          pulumi.Float64(1),
 * 			Source:            pulumi.String("vmGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.WorkloadNetworkPortMirroring;
 * import com.pulumi.azurenative.avs.WorkloadNetworkPortMirroringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadNetworkPortMirroring = new WorkloadNetworkPortMirroring("workloadNetworkPortMirroring", WorkloadNetworkPortMirroringArgs.builder()
 *             .destination("vmGroup2")
 *             .direction("BIDIRECTIONAL")
 *             .displayName("portMirroring1")
 *             .portMirroringId("portMirroring1")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .revision(1)
 *             .source("vmGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:WorkloadNetworkPortMirroring portMirroring1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/portMirroringProfiles/{portMirroringId}
 * ```
 */
public class WorkloadNetworkPortMirroring internal constructor(
    override val javaResource: com.pulumi.azurenative.avs.WorkloadNetworkPortMirroring,
) : KotlinCustomResource(javaResource, WorkloadNetworkPortMirroringMapper) {
    /**
     * Destination VM Group.
     */
    public val destination: Output<String>?
        get() = javaResource.destination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Direction of port mirroring profile.
     */
    public val direction: Output<String>?
        get() = javaResource.direction().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Display name of the port mirroring profile.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * NSX revision number.
     */
    public val revision: Output<Double>?
        get() = javaResource.revision().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Source VM Group.
     */
    public val source: Output<String>?
        get() = javaResource.source().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Port Mirroring Status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkloadNetworkPortMirroringMapper : ResourceMapper<WorkloadNetworkPortMirroring> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.avs.WorkloadNetworkPortMirroring::class == javaResource::class

    override fun map(javaResource: Resource): WorkloadNetworkPortMirroring =
        WorkloadNetworkPortMirroring(
            javaResource as
                com.pulumi.azurenative.avs.WorkloadNetworkPortMirroring,
        )
}

/**
 * @see [WorkloadNetworkPortMirroring].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkloadNetworkPortMirroring].
 */
public suspend fun workloadNetworkPortMirroring(
    name: String,
    block: suspend WorkloadNetworkPortMirroringResourceBuilder.() -> Unit,
): WorkloadNetworkPortMirroring {
    val builder = WorkloadNetworkPortMirroringResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkloadNetworkPortMirroring].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workloadNetworkPortMirroring(name: String): WorkloadNetworkPortMirroring {
    val builder = WorkloadNetworkPortMirroringResourceBuilder()
    builder.name(name)
    return builder.build()
}
