@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Connectivity to internet is enabled or disabled
 */
public enum class InternetEnum(
    public val javaValue: com.pulumi.azurenative.avs.enums.InternetEnum,
) : ConvertibleToJava<com.pulumi.azurenative.avs.enums.InternetEnum> {
    Enabled(com.pulumi.azurenative.avs.enums.InternetEnum.Enabled),
    Disabled(com.pulumi.azurenative.avs.enums.InternetEnum.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.avs.enums.InternetEnum = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.enums.InternetEnum): InternetEnum =
            InternetEnum.values().first { it.javaValue == javaType }
    }
}
