@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of identity used for the private cloud. The type 'SystemAssigned' refers to an implicitly created identity. The type 'None' will remove any identities from the Private Cloud.
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.avs.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.avs.enums.ResourceIdentityType> {
    SystemAssigned(com.pulumi.azurenative.avs.enums.ResourceIdentityType.SystemAssigned),
    None(com.pulumi.azurenative.avs.enums.ResourceIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.avs.enums.ResourceIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.enums.ResourceIdentityType): ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
