@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.EncryptionArgs.builder
import com.pulumi.azurenative.avs.kotlin.enums.EncryptionState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of customer managed encryption key
 * @property keyVaultProperties The key vault where the encryption key is stored
 * @property status Status of customer managed encryption key
 */
public data class EncryptionArgs(
    public val keyVaultProperties: Output<EncryptionKeyVaultPropertiesArgs>? = null,
    public val status: Output<Either<String, EncryptionState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.EncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.EncryptionArgs =
        com.pulumi.azurenative.avs.inputs.EncryptionArgs.builder()
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [EncryptionArgs].
 */
@PulumiTagMarker
public class EncryptionArgsBuilder internal constructor() {
    private var keyVaultProperties: Output<EncryptionKeyVaultPropertiesArgs>? = null

    private var status: Output<Either<String, EncryptionState>>? = null

    /**
     * @param value The key vault where the encryption key is stored
     */
    @JvmName("fxsxwkaprnuietwi")
    public suspend fun keyVaultProperties(`value`: Output<EncryptionKeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value Status of customer managed encryption key
     */
    @JvmName("ahjiphfotljmuqal")
    public suspend fun status(`value`: Output<Either<String, EncryptionState>>) {
        this.status = value
    }

    /**
     * @param value The key vault where the encryption key is stored
     */
    @JvmName("aupebevmdqwshwvh")
    public suspend fun keyVaultProperties(`value`: EncryptionKeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument The key vault where the encryption key is stored
     */
    @JvmName("fkckvucesudrjcfe")
    public suspend fun keyVaultProperties(argument: suspend EncryptionKeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionKeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param value Status of customer managed encryption key
     */
    @JvmName("oevdvfjlpxvwqttv")
    public suspend fun status(`value`: Either<String, EncryptionState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of customer managed encryption key
     */
    @JvmName("yofrgagflixpafpa")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of customer managed encryption key
     */
    @JvmName("wshckyklgphehmjk")
    public fun status(`value`: EncryptionState) {
        val toBeMapped = Either.ofRight<String, EncryptionState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): EncryptionArgs = EncryptionArgs(
        keyVaultProperties = keyVaultProperties,
        status = status,
    )
}
